package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.*;
import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.bcxin.tenant.open.infrastructures.valueTypes.GeoLocationValueType;
import com.bcxin.tenant.open.infrastructures.constants.BusinessConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Set;

@Schema(name = "EmployeeDetailResponse",title = "EmployeeDetailResponse 保安员详情信息")
@Getter
public class EmployeeDetailResponse extends ResponseAbstract {
    @Schema(name = "id", title = "保安员id")
    private final String id;

    @Schema(name = "name", title = "姓名")
    private final String name;

    @Schema(name = "idCardNo", title = "身份证")
    private final String idCardNo;

    @Schema(name = "contact", title = "联系方式")
    private final String contact;

    @Schema(name = "organizationId", title = "保安员所在公司Id")
    private final String organizationId;

    @Schema(name = "companyName", title = "所在公司")
    private final String companyName;

    @Schema(name = "authenticatedStatus", title = "实名认证状态")
    private final String authenticatedStatusText;

    @Schema( hidden = true, name = "dutyStatus", title = "保安员签到状态; None: 离岗(未签到); SignIn: 在岗; SignOut: 离岗(签退/离开驻勤点)")
    private final DutySignInType dutyStatus;

    @Schema(name = "dutyStatusText", title = "签到的文本描述; 保安员签到状态; None: 离岗(未签到); SignIn: 在岗; SignOut: 离岗(签退/离开驻勤点)")
    public String getDutyStatusText() {
        if (this.getDutyStatus() == null) {
            return null;
        }

        return this.getDutyStatus() == DutySignInType.SignIn ? "在岗" : "离岗";
    }

    @Schema(name = "militaryStatus", title = "兵役情况")
    private final String militaryStatus;

    @Schema(name = "securityCertificateNo", title = "资格证编号")
    private final String securityCertificateNo;

    @Schema(name = "latitude", title = "保安员所在y轴坐标")
    private final Double latitude;

    @Schema(name = "longitude", title = "保安员所在x轴坐标")
    private final Double longitude;

    @Schema(name = "securityStationId", title = "驻勤点Id")
    private final String securityStationId;

    @Schema(name = "securityStationName", title = "驻勤点名称")
    private final String securityStationName;

    @Schema(name = "tencentUserId", title = "音视频的腾讯UserId")
    private final String tencentUserId;

    @Schema(name = "tenantImUserId", title = "用户本身的腾讯UserId")
    private final String tenantImUserId;

    @Schema(name = "cid", title = "APP设备Cid的值")
    private final String cid;

    @Schema(name = "superviseDepartId", title = "所在驻勤的监管归属信息")
    private final String superviseDepartId;

    @Schema(name = "superviseDepartName", title = "所在驻勤的监管归属名称")
    private final String superviseDepartName;

    @Schema(name = "isDevice", title = "是否为硬件设备")
    private final boolean isDevice;

    private final Set<String> followedDeviceNos;

    @Schema(name = "thirdParty", title = "第三方机构; 比如: 马拉松中的志愿者、医护人员、裁判来自的单位信息")
    private String thirdParty;

    @Schema(name = "isFollowed", title = "是否关注")
    private final boolean followed;

    @Schema(name = "securityStationRailIds", title = "涉及到电子围栏信息")
    private final Set<String> securityStationRailIds;

    @Schema(name = "relativeSuperviseDepartIds", title = "relativeSuperviseDepartIds")
    private final Set<String> relativeSuperviseDepartIds;

    @Schema(name = "cLevels", title = "所在企业级别")
    private final Collection<CompanyLevel> cLevels;

    /**
     * 没有加的话,默认返回给前端的是device
     * @return
     */
    public boolean getIsDevice() {
        return this.isDevice;
    }

    @Schema(name = "certificateSituation", title = "持证情况")
    public String getCertificateSituation() {
        if (!StringUtil.isEmpty(this.getSecurityCertificateNo()) && !BusinessConstants.DefaultEmptyValue.equals(this.getSecurityCertificateNo())) {
            return "持证";
        } else {
            return "未持证";
        }
    }
    @Schema(name = "stationResponsible", title = "是否为驻勤点负责人")
    private final boolean stationResponsible;

    @Schema(name = "responsibleOfStationId", title = "所负责的驻勤点Id; 如果当前用户所在的驻勤点跟负责的驻勤点一致; 则返回当前驻勤点; 否则返回null")
    private final String responsibleOfStationId;

    @Schema(name = "hasResource", title = "是否具有调度资源")
    public boolean getHasResource() {
        return this.getTencentUserId() != null && this.getTencentUserId().length() > 0;
    }

    @Schema(name = "resourceTypes", title = "资源类型: Security=保安;Population=社会力量;Proprietor=内保单位的甲方管理员;ProprietorManaged=内保单位管理的保安人员;TemporarySecurity=临保;如果临保调度台的话, 则显式临保人员")
    private final Set<String> resourceTypes;

    @Schema(name = "institutional", title = "所属公司的机构类型")
    private final String institutional;

    @Schema(name = "institutionalName", title = "所属公司的机构类型名称")
    private final String institutionalName;

    @Schema(name = "proprietorCompanyId", title = "所服务的内保单位Id")
    private  final String proprietorCompanyId;

    @Schema(name = "proprietorCompanyName", title = "所服务的内保单位信息")
    private  final String proprietorCompanyName;

    @Schema(name = "occupationType", title = "人员类型: 文字描述; 比如: 保安人员/甲方管理员/警员/社会力量/一般职员/(临保调度台中; 当此值为'-'的时候; 需要根据stationType 与 /security-stations/station-types 中返回的id比对，并显示name的值)")
    private String occupationType;

    @Schema(name = "stationType", title = "所在岗点的类型: 比如：马拉松中, 此值作为工作人员类型的Id;可以用于获取工作类型的名称")
    private final String stationType;
    @Schema(name = "lastSyncTime", title = "最后同步时间")
    private final Timestamp lastSyncTime;

    @Schema(name = "scopePermissions", title = "调试: 可被查询范围")
    private final Set<String> scopePermissions;

    @Schema(name = "domainAdmin", title = "组织管理员")
    private final boolean domainAdmin;

    @Schema(name = "responsibleOfStationIds", title = "负责的全部关联驻勤点列表;")
    private final Set<String> responsibleOfStationIds;

    @Schema(name = "superviseRegionCode", title = "监管区域编码;")
    private final String superviseRegionCode;

    @Schema(name = "projectId", title = "项目Id")
    private final String projectId;

    @Schema(name = "projectName", title = "项目名称")
    private final String projectName;

    @Schema(name = "countOfStations", title = "所在的工作点(点位/岗点/驻勤点)")
    private final int countOfStations;

    private final String syncNote;

    public EmployeeDetailResponse(String id, String name,
                                  Double latitude,
                                  Double longitude,
                                  String idCardNo, String contact,
                                  String organizationId, String companyName,
                                  String authenticatedStatusText, DutySignInType dutyStatus,
                                  Boolean dispatchable,
                                  Timestamp lastDutyStatusChangedTime,
                                  String militaryStatus,
                                  String securityCertificateNo,
                                  String securityStationId, String securityStationName,
                                  String tencentUserId, String tenantImUserId,
                                  String superviseDepartId,
                                  String cid,
                                  boolean isDevice,
                                  String superviseDepartName,
                                  Set<String> followedDeviceNos,
                                  String thirdParty, boolean followed,
                                  Set<String> securityStationRailIds,
                                  String responsibleOfStationId,
                                  Set<String> resourceTypes,
                                  String institutional,
                                  Set<String> relativeSuperviseDepartIds,
                                  String proprietorCompanyId,
                                  String proprietorCompanyName,
                                  OccupationType occupationType,
                                  Set<String> scopePermissions,
                                  Timestamp lastSyncTime,
                                  String syncNote,
                                  boolean domainAdmin,
                                  Set<String> responsibleOfStationIds,
                                  String superviseRegionCode,
                                  int cLevel,
                                  String projectId, String projectName,
                                  String stationType, Integer countOfStations) {
        this.id = id;
        this.name = name;
        this.thirdParty = thirdParty;
        this.projectId = projectId;
        this.projectName = projectName;
        this.countOfStations = countOfStations==null?0:countOfStations.intValue();

        if (GeoLocationValueType.isValidLocation(latitude, longitude)) {
            this.latitude = latitude;
            this.longitude = longitude;
        } else {
            this.latitude = null;
            this.longitude = null;
        }

        this.idCardNo = StringUtil.isEmpty(idCardNo) ? "" : idCardNo;
        this.contact = StringUtil.isEmpty(contact) ? "" : contact;
        this.organizationId = organizationId;
        this.companyName = companyName;
        this.authenticatedStatusText = authenticatedStatusText;
        this.cLevels = CompanyLevel.getLevels(cLevel);
        this.syncNote = String.format(
                "在岗状态:%s;dispatchable=%s;时间=%s;note=%s",
                dutyStatus, dispatchable, lastDutyStatusChangedTime,
                syncNote);

        if (dutyStatus == DutySignInType.SignIn) {
            if (dispatchable != null && !dispatchable) {
                this.dutyStatus = DutySignInType.SignOut;
            } else {
                this.dutyStatus = dutyStatus;
            }
        } else {
            this.dutyStatus = dutyStatus;
        }

        this.militaryStatus = militaryStatus;
        this.securityCertificateNo = StringUtil.isEmpty(securityCertificateNo) ? "" : securityCertificateNo;
        this.securityStationId = securityStationId;
        this.securityStationName = StringUtil.isEmpty(securityStationName) ? "" : securityStationName;
        this.tencentUserId = tencentUserId;
        this.tenantImUserId = tenantImUserId;
        this.superviseDepartId = superviseDepartId;
        this.cid = cid;
        this.isDevice = isDevice;
        this.superviseDepartName = superviseDepartName;
        this.followedDeviceNos = followedDeviceNos;
        this.followed = followed;
        this.securityStationRailIds = securityStationRailIds;

        this.stationResponsible = !StringUtil.isEmpty(responsibleOfStationId) && !BusinessConstants.DefaultEmptyValue.equalsIgnoreCase(responsibleOfStationId);
        this.responsibleOfStationId = responsibleOfStationId;
        this.resourceTypes = resourceTypes;
        this.institutional = institutional;
        this.relativeSuperviseDepartIds = relativeSuperviseDepartIds;
        this.proprietorCompanyName = proprietorCompanyName;
        this.proprietorCompanyId = proprietorCompanyId;

        if (RoleType.create(institutional, companyName) == RoleType.Proprietor) {
            this.occupationType = "甲方管理员";
        } else if("0201".equalsIgnoreCase(institutional)){
            this.occupationType = "-";
        } else {
            if (this.getResourceTypes() != null && this.getResourceTypes().stream().allMatch(ii -> StringUtil.isEqual(ii, ResourceType.Population.name()))) {
                this.occupationType = "社会力量";
            } else {
                this.occupationType = occupationType == null ? "" : occupationType.getTypeName();
            }
        }

        this.institutionalName = BusinessUtil.getInstitutionalName(institutional);
        this.lastSyncTime = lastSyncTime;
        this.scopePermissions = scopePermissions;

        this.domainAdmin = domainAdmin;
        this.responsibleOfStationIds = responsibleOfStationIds;
        this.superviseRegionCode = superviseRegionCode;
        this.stationType = stationType;
    }

    public static EmployeeDetailResponse create(String id, String name,
                                                Double latitude,
                                                Double longitude,
                                                String idCardNo, String contact,
                                                String organizationId, String companyName,
                                                String authenticatedStatusText, DutySignInType dutyStatus,
                                                Boolean dispatchable,
                                                Timestamp lastDutyStatusChangedTime,
                                                String militaryStatus,
                                                String securityCertificateNo,
                                                String securityStationId, String securityStationName,
                                                String tencentUserId, String tenantImUserId,
                                                String superviseDepartId,
                                                String cid,
                                                boolean isDevice,
                                                String superviseDepartName,
                                                Set<String> followedDeviceNos,
                                                String thirdParty,
                                                boolean followed,
                                                Set<String> securityStationRailIds,
                                                String responsibleOfStationId,
                                                Set<String> resourceTypes,
                                                String institutional,
                                                Set<String> relativeSuperviseDepartIds,
                                                String proprietorCompanyId,
                                                String proprietorCompanyName,
                                                OccupationType occupationType,
                                                Set<String> scopePermissions,
                                                Timestamp lastSyncTime,
                                                String syncNote,
                                                boolean domainAdmin,
                                                Set<String> responsibleOfStationIds,
                                                String superviseRegionCode,
                                                int cLevel,
                                                String projectId, String projectName,
                                                String stationType, Integer countOfStations
                                                ) {
        return new EmployeeDetailResponse(
                id, name, latitude, longitude,
                idCardNo, contact,
                organizationId, companyName, authenticatedStatusText,
                dutyStatus, dispatchable, lastDutyStatusChangedTime, militaryStatus,
                securityCertificateNo,
                securityStationId, securityStationName, tencentUserId,
                tenantImUserId, superviseDepartId, cid, isDevice,
                superviseDepartName, followedDeviceNos, thirdParty, followed, securityStationRailIds, responsibleOfStationId,
                resourceTypes, institutional, relativeSuperviseDepartIds,
                proprietorCompanyId,
                proprietorCompanyName,
                occupationType,
                scopePermissions,
                lastSyncTime,
                syncNote,
                domainAdmin,
                responsibleOfStationIds, superviseRegionCode,
                cLevel,
                projectId, projectName,stationType, countOfStations);
    }

    public void assignThirdPartyName(String thirdPartyName) {
        this.thirdParty = thirdPartyName;
    }
}
