package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.util.Collection;

@Schema(name = "CalculatePoliceIncidentsResponse",title = "CalculatePoliceIncidentsResponse 刷新警情上报的统计")
@Getter
public class CalculatePoliceIncidentsResponse extends ResponseAbstract {
    @Schema(name = "levelCount", title = "警情上报的统计")
    private final PoliceIncidentsLevelCountResponse levelCount;
    @Schema(name = "messages", title = "前几条警情上报的消息")
    private final Collection<PoliceIncidentMessage> messages;

    public CalculatePoliceIncidentsResponse(PoliceIncidentsLevelCountResponse levelCount,
                                            Collection<PoliceIncidentMessage> messages) {
        this.levelCount = levelCount;
        this.messages = messages;
    }

    @Schema(name = "PoliceIncidentMessage", title = "PoliceIncidentMessage 警情上报消息")
    @Getter
    public static class PoliceIncidentMessage extends ResponseAbstract {
        @Schema(name = "id", title = "id")
        private String id;

        @Schema(name = "message", title = "消息内容")
        private final String message;

        @Schema(name = "latitude", title = "纬度 y")
        private final double latitude;

        @Schema(name = "longitude", title = "经度 x")
        private final double longitude;

        @Schema(name = "createdTime", title = "创建时间")
        private final String createdTime;


        public PoliceIncidentMessage(String id, String message, double latitude, double longitude, String createdTime) {
            this.id = id;
            this.message = message;
            this.latitude = latitude;
            this.longitude = longitude;
            this.createdTime = createdTime;
        }

        public static PoliceIncidentMessage create(String id, String message, double latitude, double longitude, String createdTime) {
            return new PoliceIncidentMessage(id, message, latitude, longitude, createdTime);
        }
    }
}
