package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.AttendanceSearchModel;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Data
public class MyAttendanceSearchRequest  extends SearchRequestAbstract {

    @Schema(name = "searchModel",title = "搜索模式: Today  则表示搜索今天记录; RecentWeek  则表示搜索近一周记录; RecentMonth 则表示搜索近一个月记录")
    private AttendanceSearchModel searchModel;

    @Schema(name = "employeeId", title = "人员")
    private String employeeId;

    public static MyAttendanceSearchRequest create(AttendanceSearchModel searchModel,String employeeId,int pageIndex,int pageSize) {
        MyAttendanceSearchRequest request = new MyAttendanceSearchRequest();
        request.setPageIndex(pageIndex);
        request.setPageSize(pageSize);
        request.setSearchModel(searchModel);
        request.setEmployeeId(employeeId);

        return request;
    }
}
