package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.DutySignInType;
import com.bcxin.tenant.open.infrastructures.enums.EmployeeSyncType;
import lombok.Data;

/**
 * 针对非保安人员的信息变更
 */
@Data
public class EmployeeSyncUpdateRequest extends RequestAbstract {
    private EmployeeSyncType syncType;
    private Object data;

    public static class SyncChangedEventRequestAbstract extends RequestAbstract {
    }

    @Data
    public static class SecurityStationExpiredSyncRequest extends SyncChangedEventRequestAbstract {
        private String stationId;
    }

    @Data
    public static class OrgPurseChangedEventRequest extends SyncChangedEventRequestAbstract {
        private String organizationId;
        private Long points;
    }

    @Data
    public static class DeviceBoundChangedEventRequest extends SyncChangedEventRequestAbstract {
        private String employeeId;
        private String deviceNumber;
    }

    @Data
    public static class DutyStatusChangedEventRequest extends SyncChangedEventRequestAbstract {
        private String employeeId;
        private DutySignInType dutySignInType;
    }
}
