package com.bcxin.tenant.open.jdks.requests;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;

@Schema(name = "CompanyOverviewRequest",title = "CompanyOverviewRequest 搜索业务管理的企业信息")
@Data
public class CompanyOverviewRequest  extends SearchDeskRequestAbstract {
    @Schema(name = "name",title = "公司名称")
    private String name;

    @Schema(name = "superviseDepartIds", title = "监管机构ID")
    private Collection<String> superviseDepartIds;

    @Schema(name = "hasPoints",title = "是否有联动值: null=全部; true= 有联动值; false= 无联动值")
    private Boolean hasPoints;

    @Schema(name = "hasDesk",title = "是否有调度台: null=全部; true= 有调度台; false= 无调度台")
    private Boolean hasDesk;

    @Schema(name = "hasLocation",title = "是否有经纬度坐标: null=全部; true= 有坐标; false= 无坐标")
    private Boolean hasLocation;
}
