package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.jdks.requests.enums.BroadcastMessageType;
import lombok.Data;

@Data
public class BroadcastMessageRequest extends RequestAbstract {
    private BroadcastMessageType messageType;

    private BroadcastMessageContent content;

    public BroadcastMessageRequest() {

    }

    public BroadcastMessageRequest(BroadcastMessageType messageType, BroadcastMessageContent content) {
        this.messageType = messageType;
        this.content = content;
    }

    public static BroadcastMessageRequest create(BroadcastMessageType messageType, BroadcastMessageContent content) {
        return new BroadcastMessageRequest(messageType, content);
    }
}
