package com.bcxin.tenant.open.infrastructures.flinks;

import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.enums.JobType;
import lombok.AccessLevel;
import lombok.Getter;

@Getter
public class JobParameterDTO {
    private final String name;
    private final String parameterJson;
    private final String description;
    private final JobType jobType;

    @Getter(AccessLevel.PRIVATE)
    private JobExecutorParam param;

    public JobParameterDTO(String name, JobType jobType, String parameterJson, String description) {
        this.name = name;
        this.parameterJson = parameterJson;
        this.description = description;
        this.jobType = jobType;
    }

    public static JobParameterDTO create(String name, JobType jobType, String parameterJson, String description) {
        return new JobParameterDTO(name, jobType, parameterJson, description);
    }

    public String getParam1(JsonProvider jsonProvider) {
        JobExecutorParam p = this.getJobExecutorParam(jsonProvider);

        if (p == null) {
            return null;
        }

        return p.getParam1();
    }

    public String getParam2(JsonProvider jsonProvider) {
        JobExecutorParam p = this.getJobExecutorParam(jsonProvider);

        if (p == null) {
            return null;
        }

        return p.getParam2();
    }

    private JobExecutorParam getJobExecutorParam(JsonProvider jsonProvider) {
        if (this.getParam() == null) {
            this.param = jsonProvider.toObject(JobExecutorParam.class, this.getParameterJson());
        }

        return this.param;
    }
}
