package com.bcxin.tenant.open.infrastructures.components;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;

import java.util.Collection;

public interface JsonProvider {
    <T> String getJson(T data);

    <T> T toObject(Class<T> tClass, String json);

    <T> Collection<T> toObjects(Class<T> tClass, String json);

    public static class DefaultJsonProvider implements JsonProvider {
        @Override
        public <T> String getJson(T data) {
            if(data==null) {
                return null;
            }

            return JSON.toJSONString(data, SerializerFeature.WriteMapNullValue);
        }

        @Override
        public <T> T toObject(Class<T> tClass, String json) {
            return JSON.parseObject(json, tClass);
        }

        @Override
        public <T> Collection<T> toObjects(Class<T> tClass, String json) {
            return JSON.parseArray(json, tClass);
        }
    }
}
