/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.commands;

import java.util.Collection;
import java.util.Optional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class InviteRoomUserCommandResponse {
    private final Long roomNo;
    private final Collection<InviteUsersCommandResponseItem> roomItems;

    public InviteRoomUserCommandResponse(Long roomNo, Collection<InviteUsersCommandResponseItem> roomItems) {
        this.roomNo = roomNo;
        this.roomItems = roomItems;
    }

    public static InviteRoomUserCommandResponse create(Long roomNo, Collection<InviteUsersCommandResponseItem> roomItems) {
        return new InviteRoomUserCommandResponse(roomNo, roomItems);
    }

    public String getCid(String employeeId) {
        if (!StringUtils.hasLength((String)employeeId)) {
            return null;
        }
        if (CollectionUtils.isEmpty(this.getRoomItems())) {
            return null;
        }
        Optional<InviteUsersCommandResponseItem> roomCommandItemOptional = this.getRoomItems().stream().filter(ii -> ii.getEmployeeId().equalsIgnoreCase(employeeId)).findFirst();
        if (roomCommandItemOptional.isPresent()) {
            return roomCommandItemOptional.get().getCid();
        }
        return null;
    }

    public String getEmployeeName(String employeeId) {
        if (!StringUtils.hasLength((String)employeeId)) {
            return null;
        }
        if (CollectionUtils.isEmpty(this.getRoomItems())) {
            return null;
        }
        Optional<InviteUsersCommandResponseItem> roomCommandItemOptional = this.getRoomItems().stream().filter(ii -> ii.getEmployeeId().equals(employeeId)).findFirst();
        if (roomCommandItemOptional.isPresent()) {
            return roomCommandItemOptional.get().getEmployeeName();
        }
        return null;
    }

    public Long getRoomNo() {
        return this.roomNo;
    }

    public Collection<InviteUsersCommandResponseItem> getRoomItems() {
        return this.roomItems;
    }

    public static class InviteUsersCommandResponseItem {
        private final String employeeId;
        private final String employeeName;
        private final String tenantUserId;
        private final String cid;

        public InviteUsersCommandResponseItem(String employeeId, String employeeName, String tenantUserId, String cid) {
            this.employeeId = employeeId;
            this.employeeName = employeeName;
            this.tenantUserId = tenantUserId;
            this.cid = cid;
        }

        public static InviteUsersCommandResponseItem create(String employeeId, String employeeName, String tenantUserId, String cid) {
            return new InviteUsersCommandResponseItem(employeeId, employeeName, tenantUserId, cid);
        }

        public String getEmployeeId() {
            return this.employeeId;
        }

        public String getEmployeeName() {
            return this.employeeName;
        }

        public String getTenantUserId() {
            return this.tenantUserId;
        }

        public String getCid() {
            return this.cid;
        }
    }
}

