/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.syncs.services.impls;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.bcxin.backend.domain.apps.TriggerDefinition;
import com.bcxin.backend.domain.syncs.services.ExecuteAppTaskJobService;
import com.bcxin.backend.domain.syncs.services.impls.GetAppTaskJobServiceImpl;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ExecuteAppTaskJobServiceImpl
implements ExecuteAppTaskJobService {
    private static final Logger log = LoggerFactory.getLogger(ExecuteAppTaskJobServiceImpl.class);
    @Value(value="${myapps.domain.url}")
    private String url;
    @Autowired
    GetAppTaskJobServiceImpl getAppTaskJobService;

    @Override
    public void executeTaskByTaskId() {
        String TRIGGERS_EXECUTEURL = this.url + "/api/v2/runtime/definitions/apps/%s/triggers/%s/execute";
        try {
            List<TriggerDefinition> tirggList = this.getAppTaskJobService.getApps();
            if (!ObjectUtils.isEmpty(tirggList)) {
                ((Stream)tirggList.stream().parallel()).forEach(tri -> {
                    String format = String.format(TRIGGERS_EXECUTEURL, tri.getAppId(), tri.getId());
                    log.error(format);
                    try {
                        HttpRequest httpRequest = HttpUtil.createPost((String)format);
                        HttpResponse execute = httpRequest.execute();
                        boolean ok = execute.isOk();
                        if (ok) {
                            String appsJsonStr = execute.body();
                            log.error("Finish the schedule Task(\u8bf7\u6c42={};\u54cd\u5e94={})\uff01", (Object)format, (Object)appsJsonStr);
                        } else {
                            log.error("Error for the schedule Task({})", (Object)format);
                        }
                        Thread.sleep(5000L);
                    }
                    catch (Exception e) {
                        log.error("\u63a5\u53e3\u8bf7\u6c42({})\u53d1\u751f\u5f02\u5e38", (Object)format, (Object)e);
                    }
                });
            }
            log.error("executeTaskByTaskId \u6267\u884c\u5b8c\u6bd5\uff01");
        }
        catch (Exception e) {
            log.error("executeTaskByTaskId \u6267\u884c\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
    }
}

