/*
 * Decompiled with CFR 0.152.
 */
package com.baichuanxin.openrestapi.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baichuanxin.openrestapi.common.utils.DateUtil;
import com.baichuanxin.openrestapi.common.utils.FileHandleUtil;
import com.baichuanxin.openrestapi.common.utils.OnlineTaskUtil;
import com.baichuanxin.openrestapi.configs.OneTaskConfig;
import com.baichuanxin.openrestapi.dao.mapper.ChangeLegalPersonMapper;
import com.baichuanxin.openrestapi.dtos.AttachDto;
import com.baichuanxin.openrestapi.dtos.ChangeLegalPersonDto;
import com.baichuanxin.openrestapi.dtos.FileDto;
import com.baichuanxin.openrestapi.entity.ChangeLegalPerson;
import com.baichuanxin.openrestapi.entity.Notice;
import com.baichuanxin.openrestapi.entity.RegionCode;
import com.baichuanxin.openrestapi.service.TaskInfoService;
import com.baichuanxin.openrestapi.service.impl.AttachTaskInfoServiceImpl;
import com.baichuanxin.openrestapi.service.impl.NoticeServiceImpl;
import com.baichuanxin.openrestapi.service.impl.RegionCodeServiceImpl;
import com.baichuanxin.openrestapi.service.impl.ShareholderTaskInfoServiceImpl;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChangeLegalPersonTaskInfoServiceImpl
extends ServiceImpl<ChangeLegalPersonMapper, ChangeLegalPerson>
implements TaskInfoService {
    private static final Logger log = LoggerFactory.getLogger(ChangeLegalPersonTaskInfoServiceImpl.class);
    @Autowired
    private OneTaskConfig oneTaskConfig;
    @Autowired
    private AttachTaskInfoServiceImpl attachTaskInfoService;
    @Autowired
    private ShareholderTaskInfoServiceImpl shareholderTaskInfoService;
    @Autowired
    private RegionCodeServiceImpl regionCodeService;
    @Autowired
    private NoticeServiceImpl noticeService;

    @Transactional(rollbackFor={Exception.class})
    public boolean saveTaskInfo(Notice notice) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"taskId", (Object)notice.getTaskId());
        ChangeLegalPerson one = (ChangeLegalPerson)this.getOne((Wrapper)queryWrapper);
        if (one != null) {
            log.info("==\u6570\u636e\u5df2\u7ecf\u5b58\u5728:taskId:{}", (Object)notice.getTaskId());
            notice.setStatus(Integer.valueOf(1));
            this.noticeService.updateNoticeOneByTaskId(notice);
            return false;
        }
        Map formJson = notice.getFormJson();
        ChangeLegalPersonDto changeLegalPersonDto = (ChangeLegalPersonDto)JSON.parseObject((String)JSON.toJSONString((Object)formJson), ChangeLegalPersonDto.class);
        ChangeLegalPerson changeLegalPerson = changeLegalPersonDto.convert(notice);
        RegionCode regionCode = this.regionCodeService.getRegionCode(changeLegalPersonDto.getItem_officePoliceAddress());
        changeLegalPerson.setItemOfficePoliceAddress(regionCode.getName());
        changeLegalPerson.setItemitemOfficePoliceAddressid(regionCode.getId());
        changeLegalPerson.setItemOfficePoliceidindex(regionCode.getIndexTree());
        boolean saveResult = this.save((Object)changeLegalPerson);
        boolean saveShare = this.shareholderTaskInfoService.saveOtherInfo(notice.getTaskId(), changeLegalPersonDto.getItem_shareholder(), changeLegalPerson.getId());
        boolean saveFileDataResult = this.attachTaskInfoService.saveOtherInfo(notice, changeLegalPerson.getId());
        List attachList = notice.getAttachList();
        Map<String, List<AttachDto>> map = attachList.stream().collect(Collectors.groupingBy(AttachDto::getMaterialId));
        for (String key : map.keySet()) {
            List<AttachDto> attachDtos = map.get(key);
            int i = 1;
            for (AttachDto attachDto : attachDtos) {
                try {
                    FileHandleUtil.saveApplyFileHandle((String)StrUtil.join((CharSequence)"", (Object[])new Object[]{this.oneTaskConfig.getDownloadUrl(), attachDto.getAttachPath()}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getSaveFile(), notice.getMatId(), notice.getTaskId(), attachDto.getMaterialId(), i}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getSaveFile(), notice.getMatId(), notice.getTaskId(), attachDto.getMaterialId(), i, StrUtil.join((CharSequence)".", (Object[])new Object[]{attachDto.getMaterialName(), attachDto.getAttachType()})}));
                    ++i;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return saveFileDataResult && saveResult && saveShare;
    }

    public List<String> returnTaskResult(List<Notice> noticeList) {
        ArrayList<String> resultList = new ArrayList<String>();
        ArrayList<String> taskIdList = new ArrayList<String>();
        for (Notice notice : noticeList) {
            taskIdList.add(notice.getTaskId());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"taskId", taskIdList);
        queryWrapper.in((Object)"ITEM_AUDITSTATUS", new Object[]{"0", "1"});
        List changeLegalPersonList = this.list((Wrapper)queryWrapper);
        for (ChangeLegalPerson changeLegalPerson : changeLegalPersonList) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("taskId", changeLegalPerson.getTaskId());
            map.put("userName", "\u6e56\u5357\u7701\u4fdd\u5b89\u76d1\u7ba1\u4fe1\u606f\u7cfb\u7edf");
            map.put("eventName", OnlineTaskUtil.convertStatus((String)changeLegalPerson.getItemAuditStatus()));
            map.put("opinion", OnlineTaskUtil.convertStatus((String)OnlineTaskUtil.convertStatus((String)changeLegalPerson.getItemAuditStatus())));
            map.put("endTime", DateUtil.dateFormatter((Date)changeLegalPerson.getItemOverTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            map.put("isdelivery", changeLegalPerson.getIsdelivery());
            log.info("\u53d1\u9001\u5ba1\u6838\u7ed3\u679c");
            boolean b = OnlineTaskUtil.returnResult((String)JSON.toJSONString(map));
            log.info("\u53d1\u9001\u7ed3\u679c\u7269");
            if (changeLegalPerson.getItemAuditStatus().equals("0")) {
                boolean result0 = this.sentResultFile(changeLegalPerson.getTaskId(), changeLegalPerson.getItemAcceptanceFile(), "0");
                if (!b || !result0) continue;
                resultList.add(changeLegalPerson.getTaskId());
                continue;
            }
            if (!changeLegalPerson.getItemAuditStatus().equals("1")) continue;
            boolean result = OnlineTaskUtil.returnResultFile((String)changeLegalPerson.getTaskId(), (String)changeLegalPerson.getItemCompanyName(), (File)FileHandleUtil.fileHandle((String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), StrUtil.join((CharSequence)".", (Object[])new Object[]{changeLegalPerson.getTaskId(), "zip"})})), (String)"2");
            if (!b || !result) continue;
            resultList.add(changeLegalPerson.getTaskId());
        }
        return resultList;
    }

    public boolean sentResultFile(String taskID, String fileListString, String needFeedBack) {
        List fileDtos = JSON.parseArray((String)fileListString, FileDto.class);
        boolean resultNoticeFile = false;
        for (FileDto fileDto : fileDtos) {
            resultNoticeFile = OnlineTaskUtil.returnResultFile((String)taskID, (String)fileDto.getName(), (File)FileHandleUtil.fileHandle((String)FileHandleUtil.strHandle((String)this.oneTaskConfig.getResultFilePath(), (String)fileDto.getPath())), (String)needFeedBack);
        }
        return resultNoticeFile;
    }

    public List<ChangeLegalPerson> getUnGetEC() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ITEM_AUDITSTATUS", (Object)"1");
        queryWrapper.eq((Object)"licenseStatus", (Object)"0");
        queryWrapper.isNotNull((Object)"ITEM_USCC");
        List changeLegalPersonList = this.list((Wrapper)queryWrapper);
        return changeLegalPersonList;
    }

    public boolean updateStatusAndfile(String id, String status, String filePath) {
        UpdateWrapper changeLegalPersonUpdateWrapper = new UpdateWrapper();
        changeLegalPersonUpdateWrapper.set((Object)"licenseStatus", (Object)status);
        changeLegalPersonUpdateWrapper.set((Object)"item_service_file", (Object)filePath);
        changeLegalPersonUpdateWrapper.eq((Object)"id", (Object)id);
        boolean updateStatus = this.update((Wrapper)changeLegalPersonUpdateWrapper);
        return updateStatus;
    }

    public boolean updateLicenseStatus(String id, String status) {
        UpdateWrapper changeWrapper = new UpdateWrapper();
        changeWrapper.eq((Object)"id", (Object)id);
        changeWrapper.set((Object)"licenseStatus", (Object)status);
        boolean updateStatus = this.update((Wrapper)changeWrapper);
        return updateStatus;
    }

    public boolean updateByFeedBack(String taskId, String filePath) {
        UpdateWrapper changeLegalPersonUpdateWrapper = new UpdateWrapper();
        changeLegalPersonUpdateWrapper.eq((Object)"taskId", (Object)taskId);
        changeLegalPersonUpdateWrapper.set((Object)"item_notice_state", (Object)"\u5df2\u7b7e\u6536");
        changeLegalPersonUpdateWrapper.set((Object)"item_reach_state", (Object)"\u5df2\u7b7e\u6536");
        changeLegalPersonUpdateWrapper.set((Object)"item_service_state", (Object)"\u5df2\u7b7e\u6536");
        changeLegalPersonUpdateWrapper.set((Object)"item_completion_state", (Object)"\u5df2\u7b7e\u6536");
        changeLegalPersonUpdateWrapper.set((Object)"ITEM_ENTERPRISE_COMPLETION_FILE", (Object)filePath);
        changeLegalPersonUpdateWrapper.set((Object)"ITEM_ENTERPRISE_REACH_FILE", (Object)filePath);
        boolean status = this.update((Wrapper)changeLegalPersonUpdateWrapper);
        return status;
    }
}

