/*
 * Decompiled with CFR 0.152.
 */
package com.baichuanxin.openrestapi.scheduling;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baichuanxin.openrestapi.common.utils.FileHandleUtil;
import com.baichuanxin.openrestapi.common.utils.OnlineTaskUtil;
import com.baichuanxin.openrestapi.configs.OneTaskConfig;
import com.baichuanxin.openrestapi.dtos.FileDto;
import com.baichuanxin.openrestapi.entity.ChangeLegalPerson;
import com.baichuanxin.openrestapi.entity.Notice;
import com.baichuanxin.openrestapi.entity.SecurityServicek;
import com.baichuanxin.openrestapi.factorys.TaskFactory;
import com.baichuanxin.openrestapi.service.NoticeService;
import com.baichuanxin.openrestapi.service.TaskInfoService;
import com.baichuanxin.openrestapi.service.impl.ChangeLegalPersonTaskInfoServiceImpl;
import com.baichuanxin.openrestapi.service.impl.SecurityServicekTaskInfoServiceImpl;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class OnlineServiceTask {
    private static final Logger log = LoggerFactory.getLogger(OnlineServiceTask.class);
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private OneTaskConfig oneTaskConfig;
    @Autowired
    private SecurityServicekTaskInfoServiceImpl servicekServiceImpl;
    @Autowired
    private ChangeLegalPersonTaskInfoServiceImpl changeLegalPersonImpl;

    @Scheduled(fixedDelay=180000L)
    public void getDataTask() {
        log.info("========================\u5f00\u59cb\u83b7\u53d6\u529e\u4ef6\u6570\u636e========================");
        Notice unGetTask = this.noticeService.getUnFinishTask();
        if (unGetTask == null) {
            log.info("=================\u7ed3\u675f\u83b7\u53d6\u529e\u4ef6\u6570\u636e\uff0c0\u4e2a\u529e\u4ef6=============================");
        } else {
            String taskResultData = OnlineTaskUtil.getTaskInfo((String)unGetTask.getTaskId());
            if (!taskResultData.equals("false")) {
                Notice notice = (Notice)JSON.parseObject((String)taskResultData, Notice.class);
                TaskInfoService taskInfoService = TaskFactory.creatTaskService((String)notice.getMatId());
                log.info("==================================\u5f00\u59cb\u4fdd\u5b58\u4e1a\u52a1\u6570\u636e\u3001\u4ee5\u53ca\u6587\u4ef6taskID=={}", (Object)notice.getTaskId());
                boolean saveResult = taskInfoService.saveTaskInfo(notice);
                log.info("==================================\u54cd\u5e94\u4f53Data=={}", (Object)taskResultData);
                if (saveResult) {
                    HashMap<String, String> confirmMap = new HashMap<String, String>();
                    confirmMap.put("confirmType", "0");
                    boolean b = OnlineTaskUtil.taskConfirm((String)notice.getTaskId(), confirmMap);
                    log.info("=======\u786e\u8ba4\u786e\u8ba4\u7ed3\u679c{}", (Object)b);
                    if (b) {
                        notice.setStatus(Integer.valueOf(1));
                        this.noticeService.updateNoticeOneByTaskId(notice);
                    }
                }
                log.info("============\u529e\u4ef6\u6570\u636e\u83b7\u53d6\u5b8c\u6210\u529e\u4ef6ID\uff1a{}======================", (Object)unGetTask.getTaskId());
            } else {
                log.info("=========\u529e\u4ef6\u6570\u636e\u83b7\u53d6\u5931\u8d25\u529e\u4ef6ID\uff1a{}==========================", (Object)unGetTask.getTaskId());
            }
        }
    }

    @Scheduled(fixedDelay=180000L)
    public void certificateReturnResultTask() {
        List noticeList = this.noticeService.getUnReturnList(1, 0, "37e6e2d36ccf44e9be54b979ed5e443b");
        if (noticeList.size() != 0) {
            TaskInfoService taskInfoService = TaskFactory.creatTaskService((String)"37e6e2d36ccf44e9be54b979ed5e443b");
            List taskIdList = taskInfoService.returnTaskResult(noticeList);
            for (String taskId : taskIdList) {
                this.noticeService.updateNoticeStatus(taskId, 2, 2);
            }
        }
    }

    @Scheduled(fixedDelay=180000L)
    public void securityServicekReturnResultTask() {
        List noticeList = this.noticeService.getUnReturnList(1, 1, "4e73cab123ad4369a6b0bb30c726e8c2");
        if (noticeList.size() > 0) {
            TaskInfoService taskInfoService = TaskFactory.creatTaskService((String)"4e73cab123ad4369a6b0bb30c726e8c2");
            List taskIdList = taskInfoService.returnTaskResult(noticeList);
            for (String taskId : taskIdList) {
                this.noticeService.updateNoticeStatus(taskId, 2, 2);
            }
        }
    }

    @Scheduled(fixedDelay=180000L)
    public void changeLegalReturnResultTask() {
        log.info("=======================\u6cd5\u4eba\u53d8\u66f4\u7ed3\u679c\u7269\u8fd4\u56de====================");
        List noticeList = this.noticeService.getUnReturnList(1, 1, "e34482ea3e1a40cd98ad7fc2603f7b72");
        if (noticeList.size() > 0) {
            TaskInfoService taskInfoService = TaskFactory.creatTaskService((String)"e34482ea3e1a40cd98ad7fc2603f7b72");
            List taskIdList = taskInfoService.returnTaskResult(noticeList);
            for (String taskId : taskIdList) {
                this.noticeService.updateNoticeStatus(taskId, 2, 2);
            }
        }
    }

    @Scheduled(fixedDelay=180000L)
    public void returnResultAndFile1Task() {
        log.info("=======================\u81ea\u62db\u5355\u4f4d\u5907\u6848\u7ed3\u679c\u7269\u8fd4\u56de\u5f00\u59cb====================");
        List noticeList3 = this.noticeService.getUnReturnList(1, 0, "b3ff45e15474477c8b40a26798cc8455");
        if (noticeList3.size() > 0) {
            TaskInfoService taskInfoService = TaskFactory.creatTaskService((String)"b3ff45e15474477c8b40a26798cc8455");
            List taskIds = taskInfoService.returnTaskResult(noticeList3);
            for (String taskId : taskIds) {
                this.noticeService.updateNoticeStatus(taskId, 2, 2);
            }
            log.info("=====================\u81ea\u62db\u5355\u4f4d\u5907\u6848\u7ed3\u679c\u7269\u8fd4\u56de\u7ed3\u675f=====================");
        }
    }

    @Scheduled(fixedDelay=180000L)
    public void returnResultAndFile2Task() {
        List noticeList4 = this.noticeService.getUnReturnList(1, 0, "dacb2c29fec249b6bc328a2babd0cbd0");
        if (noticeList4.size() > 0) {
            TaskInfoService taskInfoService = TaskFactory.creatTaskService((String)"dacb2c29fec249b6bc328a2babd0cbd0");
            List taskIds = taskInfoService.returnTaskResult(noticeList4);
            for (String taskId : taskIds) {
                this.noticeService.updateNoticeStatus(taskId, 2, 2);
            }
        }
    }

    @Scheduled(fixedDelay=180000L)
    public void returnResultAndFile3Task() {
        List noticeList5 = this.noticeService.getUnReturnList(1, 0, "e2878452c42743babc9b1a4d75fd4b1d");
        if (noticeList5.size() > 0) {
            TaskInfoService taskInfoService = TaskFactory.creatTaskService((String)"e2878452c42743babc9b1a4d75fd4b1d");
            List taskIds = taskInfoService.returnTaskResult(noticeList5);
            for (String taskId : taskIds) {
                this.noticeService.updateNoticeStatus(taskId, 2, 2);
            }
        }
    }

    @Scheduled(fixedDelay=180000L)
    public void checkTaskFile() {
        log.info("====\u68c0\u67e5\u9700\u8981\u53d1\u9001\u7ed3\u679c\u7269\u7684\u4efb\u52a1==========");
        List checkTaskFile = this.noticeService.getCheckTaskFile();
        for (Notice notice : checkTaskFile) {
            List publicCompletion;
            List publicReachFile;
            List acceptanceFile;
            if (notice.getMatId().equals("4e73cab123ad4369a6b0bb30c726e8c2")) {
                log.info("====\u68c0\u67e5\u9700\u8981\u53d1\u9001\u7ed3\u679c\u7269\u7684\u4efb\u52a1\uff1a\u4fdd\u5b89\u670d\u52a1\u516c\u53f8\u8bbe\u7acb==========");
                SecurityServicek securityServicek = (SecurityServicek)this.servicekServiceImpl.getById((Serializable)((Object)StrUtil.join((CharSequence)"--", (Object[])new Object[]{notice.getTaskId(), "__0TXoiEr3uNf7rO0sduB"})));
                if (!Objects.isNull(securityServicek) && securityServicek.getItemAuditStatus().equals("0")) {
                    if (!StrUtil.isNotBlank((CharSequence)securityServicek.getItemAcceptanceFile())) continue;
                    this.noticeService.updateNoticeStatus(notice.getTaskId(), 1, 1);
                    continue;
                }
                if (Objects.isNull(securityServicek) || !securityServicek.getItemAuditStatus().equals("1") || !StrUtil.isNotBlank((CharSequence)securityServicek.getItemAcceptanceFile()) || !StrUtil.isNotBlank((CharSequence)securityServicek.getItemPublicReachFile()) || !StrUtil.isNotBlank((CharSequence)securityServicek.getItemPublicCompletionFile())) continue;
                acceptanceFile = JSON.parseArray((String)securityServicek.getItemAcceptanceFile(), FileDto.class);
                publicReachFile = JSON.parseArray((String)securityServicek.getItemPublicReachFile(), FileDto.class);
                publicCompletion = JSON.parseArray((String)securityServicek.getItemPublicCompletionFile(), FileDto.class);
                try {
                    FileHandleUtil.moveFile((String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), notice.getTaskId()}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultFilePath(), ((FileDto)acceptanceFile.get(0)).getPath()}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), notice.getTaskId(), ((FileDto)acceptanceFile.get(0)).getName()}));
                    FileHandleUtil.moveFile((String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), notice.getTaskId()}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultFilePath(), ((FileDto)publicReachFile.get(0)).getPath()}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), notice.getTaskId(), ((FileDto)publicReachFile.get(0)).getName()}));
                    FileHandleUtil.moveFile((String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), notice.getTaskId()}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultFilePath(), ((FileDto)publicCompletion.get(0)).getPath()}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), notice.getTaskId(), ((FileDto)publicCompletion.get(0)).getName()}));
                    FileHandleUtil.filePackage((String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), StrUtil.join((CharSequence)".", (Object[])new Object[]{notice.getTaskId(), "zip"})}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), notice.getTaskId()}));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.noticeService.updateNoticeStatus(notice.getTaskId(), 1, 1);
                continue;
            }
            if (!notice.getMatId().equals("e34482ea3e1a40cd98ad7fc2603f7b72")) continue;
            log.info("====\u68c0\u67e5\u9700\u8981\u53d1\u9001\u7ed3\u679c\u7269\u7684\u4efb\u52a1\uff1a\u6cd5\u4eba\u53d8\u66f4==========");
            ChangeLegalPerson changeLegal = (ChangeLegalPerson)this.changeLegalPersonImpl.getById((Serializable)((Object)StrUtil.join((CharSequence)"--", (Object[])new Object[]{notice.getTaskId(), "__5pbeYTFpNEdQdpDbtG7"})));
            log.info("\u68c0\u67e5\u529e\u4ef6\u72b6\u6001\uff1a{}", (Object)changeLegal.getItemAuditStatus());
            if (!Objects.isNull(changeLegal) && changeLegal.getItemAuditStatus().equals("0")) {
                if (!StrUtil.isNotBlank((CharSequence)changeLegal.getItemAcceptanceFile())) break;
                this.noticeService.updateNoticeStatus(notice.getTaskId(), 1, 1);
                break;
            }
            if (Objects.isNull(changeLegal) || !changeLegal.getItemAuditStatus().equals("1")) continue;
            log.info("\u8fdb\u5165\u5230\u6587\u4ef6\u5224\u65ad\uff1a{}", (Object)changeLegal.getItemAuditStatus());
            if (!StrUtil.isNotBlank((CharSequence)changeLegal.getItemAcceptanceFile()) || !StrUtil.isNotBlank((CharSequence)changeLegal.getItemPublicReachFile()) || !StrUtil.isNotBlank((CharSequence)changeLegal.getItemPublicCompletionFile()) || !StrUtil.isNotBlank((CharSequence)changeLegal.getItemServiceFile())) continue;
            acceptanceFile = JSON.parseArray((String)changeLegal.getItemAcceptanceFile(), FileDto.class);
            publicReachFile = JSON.parseArray((String)changeLegal.getItemPublicReachFile(), FileDto.class);
            publicCompletion = JSON.parseArray((String)changeLegal.getItemPublicCompletionFile(), FileDto.class);
            List serviceFile = JSON.parseArray((String)changeLegal.getItemServiceFile(), FileDto.class);
            try {
                FileHandleUtil.moveFile((String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), notice.getTaskId()}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultFilePath(), ((FileDto)acceptanceFile.get(0)).getPath()}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), notice.getTaskId(), ((FileDto)acceptanceFile.get(0)).getName()}));
                FileHandleUtil.moveFile((String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), notice.getTaskId()}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultFilePath(), ((FileDto)publicReachFile.get(0)).getPath()}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), notice.getTaskId(), ((FileDto)publicReachFile.get(0)).getName()}));
                FileHandleUtil.moveFile((String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), notice.getTaskId()}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultFilePath(), ((FileDto)publicCompletion.get(0)).getPath()}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), notice.getTaskId(), ((FileDto)publicCompletion.get(0)).getName()}));
                FileHandleUtil.moveFile((String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), notice.getTaskId()}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultFilePath(), ((FileDto)serviceFile.get(0)).getPath()}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), notice.getTaskId(), ((FileDto)serviceFile.get(0)).getName()}));
                FileHandleUtil.filePackage((String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), StrUtil.join((CharSequence)".", (Object[])new Object[]{notice.getTaskId(), "zip"})}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getResultPackagePath(), notice.getTaskId()}));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.noticeService.updateNoticeStatus(notice.getTaskId(), 1, 1);
        }
    }

    @Scheduled(fixedDelay=180000L)
    public void getFeedBack() throws IOException {
        List unReturnList = this.noticeService.getUnReturnList(2, 2, "4e73cab123ad4369a6b0bb30c726e8c2");
        for (Notice notice : unReturnList) {
            int i = 1;
            String feedBackString = OnlineTaskUtil.getFeedBack((String)notice.getTaskId());
            if (feedBackString.equals("false")) continue;
            List list = (List)JSON.parseObject((String)feedBackString, List.class);
            ArrayList lists = new ArrayList();
            for (Map stringMap : list) {
                String attachUrl = stringMap.get("feedbackAttachUrl").toString();
                String fileSuffix = FileUtil.getSuffix((String)attachUrl);
                log.info("\u7528\u6237\u56de\u6267\u6587\u4ef6\u540e\u7f00\u540d{}", (Object)fileSuffix);
                FileHandleUtil.saveApplyFileHandle((String)StrUtil.join((CharSequence)"", (Object[])new Object[]{this.oneTaskConfig.getDownloadUrl(), attachUrl}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getSaveFile(), notice.getMatId(), notice.getTaskId(), stringMap.get("feedbackId"), i}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getSaveFile(), notice.getMatId(), notice.getTaskId(), stringMap.get("feedbackId"), i, StrUtil.join((CharSequence)".", (Object[])new Object[]{"\u56de\u6267", fileSuffix})}));
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("uid", "");
                map1.put("path", StrUtil.join((CharSequence)"/", (Object[])new Object[]{"/uploads/onetask", notice.getMatId(), notice.getTaskId(), stringMap.get("feedbackId"), i, StrUtil.join((CharSequence)".", (Object[])new Object[]{"\u56de\u6267", fileSuffix})}));
                map1.put("originalPath", StrUtil.join((CharSequence)"/", (Object[])new Object[]{"/uploads/onetask", notice.getMatId(), notice.getTaskId(), stringMap.get("feedbackId"), i, StrUtil.join((CharSequence)".", (Object[])new Object[]{"\u56de\u6267", fileSuffix})}));
                map1.put("name", StrUtil.join((CharSequence)".", (Object[])new Object[]{"\u56de\u6267", fileSuffix}));
                lists.add(map1);
                ++i;
            }
            boolean b = this.servicekServiceImpl.updateByFeedBack(notice.getTaskId(), JSON.toJSONString(lists));
            if (!b) continue;
            this.noticeService.updateNoticeStatus(notice.getTaskId(), 3, 3);
        }
    }

    @Scheduled(fixedDelay=180000L)
    public void getChangeKFeedBack() throws IOException {
        List unReturnList = this.noticeService.getUnReturnList(2, 2, "e34482ea3e1a40cd98ad7fc2603f7b72");
        for (Notice notice : unReturnList) {
            int i = 1;
            String feedBackString = OnlineTaskUtil.getFeedBack((String)notice.getTaskId());
            if (feedBackString.equals("false")) continue;
            List list = (List)JSON.parseObject((String)feedBackString, List.class);
            ArrayList lists = new ArrayList();
            for (Map stringMap : list) {
                String attachUrl = stringMap.get("feedbackAttachUrl").toString();
                String fileSuffix = FileUtil.getSuffix((String)attachUrl);
                log.info("\u7528\u6237\u56de\u6267\u6587\u4ef6\u540e\u7f00\u540d{}", (Object)fileSuffix);
                FileHandleUtil.saveApplyFileHandle((String)StrUtil.join((CharSequence)"", (Object[])new Object[]{this.oneTaskConfig.getDownloadUrl(), attachUrl}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getSaveFile(), notice.getMatId(), notice.getTaskId(), stringMap.get("feedbackId"), i}), (String)StrUtil.join((CharSequence)"/", (Object[])new Object[]{this.oneTaskConfig.getSaveFile(), notice.getMatId(), notice.getTaskId(), stringMap.get("feedbackId"), i, StrUtil.join((CharSequence)".", (Object[])new Object[]{"\u56de\u6267", fileSuffix})}));
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("uid", "");
                map1.put("path", StrUtil.join((CharSequence)"/", (Object[])new Object[]{"/uploads/onetask", notice.getMatId(), notice.getTaskId(), stringMap.get("feedbackId"), i, StrUtil.join((CharSequence)".", (Object[])new Object[]{"\u56de\u6267", fileSuffix})}));
                map1.put("originalPath", StrUtil.join((CharSequence)"/", (Object[])new Object[]{"/uploads/onetask", notice.getMatId(), notice.getTaskId(), stringMap.get("feedbackId"), i, StrUtil.join((CharSequence)".", (Object[])new Object[]{"\u56de\u6267", fileSuffix})}));
                map1.put("name", StrUtil.join((CharSequence)".", (Object[])new Object[]{"\u56de\u6267", fileSuffix}));
                lists.add(map1);
                ++i;
            }
            boolean b = this.changeLegalPersonImpl.updateByFeedBack(notice.getTaskId(), JSON.toJSONString(lists));
            if (!b) continue;
            this.noticeService.updateNoticeStatus(notice.getTaskId(), 3, 3);
        }
    }
}

