/*
 * Decompiled with CFR 0.152.
 */
package com.oppo.push.server;

import com.alibaba.fastjson.JSON;
import com.oppo.push.server.Auth;
import com.oppo.push.server.HttpClientTool;
import com.oppo.push.server.MessageTool;
import com.oppo.push.server.Notification;
import com.oppo.push.server.RequestPath;
import com.oppo.push.server.Result;
import com.oppo.push.server.Target;
import com.oppo.push.server.Validate;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;

public class Sender {
    private String appKey;
    private String masterSecret;
    private String token;
    private Long createTime;

    public Sender(String appKey, String masterSecret) throws Exception {
        this.appKey = appKey;
        this.masterSecret = masterSecret;
        HttpClientTool.init();
        this.setToken(this.appKey, this.masterSecret);
    }

    private void setToken(String appKey, String masterSecret) throws Exception {
        Result result = Auth.getAuthResult(appKey, masterSecret);
        if (result != null && !Validate.isEmpty(result.getToken())) {
            this.token = result.getToken();
            this.createTime = result.getCreateTime();
        }
    }

    public Result unicastNotification(Notification notification, Target target) throws Exception {
        notification.validate();
        Map<String, Object> message = MessageTool.newMessage(target);
        message.put("notification", MessageTool.getNotification(notification));
        Map<String, Object> body = MessageTool.newBody(this.token);
        body.put("message", JSON.toJSONString(message));
        return HttpClientTool.httpPostWithToken(RequestPath.NOTIFICATION_UNICAST, body, this);
    }

    public Result broadcastNotification(String messageId, Target target) throws Exception {
        Map<String, Object> body = MessageTool.newBody(target, this.token);
        MessageTool.setMessageId(body, messageId);
        return HttpClientTool.httpPostWithToken(RequestPath.NOTIFICATION_BROADCAST, body, this);
    }

    public Result uploadBigPicture(Integer pictureTtl, File file) throws Exception {
        Map<String, Object> body = MessageTool.newBody(this.token);
        MessageTool.setPictureTtl(body, pictureTtl);
        Validate.validatePictureType(file);
        Validate.validateFileMaxSize(file, 0x100000L);
        return HttpClientTool.multipartHttpPostWithToken(RequestPath.UPLOAD_BIG_PICTURE, body, file, this);
    }

    public Result uploadSmallPicture(Integer pictureTtl, File file) throws Exception {
        Map<String, Object> body = MessageTool.newBody(this.token);
        MessageTool.setPictureTtl(body, pictureTtl);
        Validate.validatePictureType(file);
        Validate.validateFileMaxSize(file, 51200L);
        return HttpClientTool.multipartHttpPostWithToken(RequestPath.UPLOAD_SMALL_PICTURE, body, file, this);
    }

    public Result saveNotification(Notification notification) throws Exception {
        notification.validate();
        Map<String, Object> body = MessageTool.newBody(this.token);
        body.putAll(MessageTool.getNotification(notification));
        return HttpClientTool.httpPostWithToken(RequestPath.NOTIFICATION_SAVE_MESSAGE, body, this);
    }

    public Result unicastBatchNotification(Map<Target, Notification> notificationMessages) throws Exception {
        Map<String, Object> body = MessageTool.newBody(this.token);
        ArrayList<Map<String, Object>> messages = new ArrayList<Map<String, Object>>();
        for (Map.Entry<Target, Notification> entry : notificationMessages.entrySet()) {
            Target target = entry.getKey();
            Notification notification = entry.getValue();
            try {
                notification.validate();
                Map<String, Object> message = MessageTool.newMessage(target);
                message.put("notification", MessageTool.getNotification(notification));
                messages.add(message);
            }
            catch (IllegalArgumentException e) {
                String string = String.format("%s    target:%s  notification:%s ", e.getMessage(), JSON.toJSON((Object)target), notification);
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string, e);
                throw illegalArgumentException;
            }
        }
        body.put("messages", JSON.toJSONString(messages));
        return HttpClientTool.httpPostWithToken(RequestPath.NOTIFICATION_UNICAST_BATCH, body, this);
    }

    String getAppKey() {
        return this.appKey;
    }

    String getMasterSecret() {
        return this.masterSecret;
    }

    void setToken(String token) {
        this.token = token;
    }

    void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }
}

