/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.sys;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.risk.cache.redis.RedisUtil;
import com.bcxin.risk.common.dao.RegionDao;
import com.bcxin.risk.common.domain.Region;
import com.bcxin.risk.constant.RedisKeyConst;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysRegionUtil {
    @Resource
    private RegionDao regionDao;
    @Resource
    private RedisUtil redisUtil;
    private static List<Region> CACHE_KEY_REGION_PROVINCE_LIST = Lists.newArrayList();
    private static List<Region> CACHE_KEY_REGION_CITY_LIST = Lists.newArrayList();
    private static List<Region> CACHE_KEY_REGION_AREA_LIST = Lists.newArrayList();
    private static Map<String, Region> CACHE_KEY_REGION_PROVINCE_MAP = Maps.newHashMap();
    private static Map<String, Collection<Region>> CACHE_KEY_REGION_UNIT_MAP = Maps.newHashMap();

    private void setRegionMap() {
        List rList = this.regionDao.selectRegionList();
        LinkedHashMap regionMap = Maps.newLinkedHashMap();
        for (Region region : rList) {
            regionMap.put(region.getOid() + "", region);
        }
        this.redisUtil.addAllHashValue(RedisKeyConst.REDIS_KEY_REGION, regionMap, 604800L);
    }

    public Collection<Region> provinceMap() {
        if (CollectionUtil.isNotEmpty(CACHE_KEY_REGION_PROVINCE_LIST)) {
            return CACHE_KEY_REGION_PROVINCE_LIST;
        }
        List<Region> rList = new ArrayList();
        List redisData1 = JSONObject.parseArray((String)((String)this.redisUtil.getValue(RedisKeyConst.REDIS_KEY_INDEX_ORG_VALUE_PREFIX + "_region_province_list")), Region.class);
        if (redisData1 == null || redisData1.size() <= 0) {
            rList = this.regionDao.selectProvinceRegionList();
            this.redisUtil.addValue(RedisKeyConst.REDIS_KEY_INDEX_ORG_VALUE_PREFIX + "_region_province_list", JSON.toJSONString(rList), 3600L);
        } else {
            rList = redisData1;
        }
        for (Region region : rList) {
            CACHE_KEY_REGION_PROVINCE_MAP.put(region.getOid() + "", region);
        }
        return rList;
    }

    public Map<String, Collection<Region>> cityMap() {
        if (CollectionUtil.isNotEmpty(CACHE_KEY_REGION_CITY_LIST)) {
            ArrayListMultimap cMap = ArrayListMultimap.create();
            for (Region region : CACHE_KEY_REGION_CITY_LIST) {
                cMap.put((Object)(region.getParent_id() + ""), (Object)region);
            }
            return cMap.asMap();
        }
        ArrayListMultimap cMap = ArrayListMultimap.create();
        CACHE_KEY_REGION_CITY_LIST = this.regionDao.selectCityRegionList();
        for (Region region : CACHE_KEY_REGION_CITY_LIST) {
            cMap.put((Object)(region.getParent_id() + ""), (Object)region);
        }
        return cMap.asMap();
    }

    public Collection<Region> cityMap(String parentId) {
        return this.cityMap().get(parentId);
    }

    public Map<String, Collection<Region>> areaMap() {
        if (CollectionUtil.isNotEmpty(CACHE_KEY_REGION_AREA_LIST)) {
            ArrayListMultimap cMap = ArrayListMultimap.create();
            for (Region region : CACHE_KEY_REGION_AREA_LIST) {
                cMap.put((Object)(region.getParent_id() + ""), (Object)region);
            }
            return cMap.asMap();
        }
        ArrayListMultimap cMap = ArrayListMultimap.create();
        CACHE_KEY_REGION_AREA_LIST = this.regionDao.selectAreaRegionList();
        for (Region region : CACHE_KEY_REGION_AREA_LIST) {
            cMap.put((Object)(region.getParent_id() + ""), (Object)region);
        }
        return cMap.asMap();
    }

    public Collection<Region> areaMap(String parentId) {
        return this.areaMap().get(parentId);
    }

    public Collection<Region> unitMap(String parentId) {
        if (MapUtil.isNotEmpty(CACHE_KEY_REGION_UNIT_MAP)) {
            return CACHE_KEY_REGION_UNIT_MAP.get(parentId);
        }
        ArrayListMultimap uMap = ArrayListMultimap.create();
        List unitList = this.regionDao.selectUnitRegionList();
        for (Region region : unitList) {
            uMap.put((Object)region.getParent_id(), (Object)region);
        }
        CACHE_KEY_REGION_UNIT_MAP = uMap.asMap();
        return CACHE_KEY_REGION_UNIT_MAP.get(parentId);
    }

    public Region getRegionById(String id) {
        Object obj = this.redisUtil.getHashValue(RedisKeyConst.REDIS_KEY_REGION, id);
        if (obj == null) {
            this.setRegionMap();
            obj = this.redisUtil.getHashValue(RedisKeyConst.REDIS_KEY_REGION, id);
        }
        return (Region)obj;
    }

    public Region getProvinceRegionById(String id) {
        return CACHE_KEY_REGION_PROVINCE_MAP.get(id);
    }
}

