/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.sys;

import cn.hutool.core.map.MapUtil;
import com.bcxin.risk.common.dao.DictDao;
import com.bcxin.risk.common.domain.Dict;
import com.bcxin.risk.common.mapper.JsonMapper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysDictUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysDictUtil.class);
    @Resource
    private DictDao dictDao;
    private Map<String, Collection<Dict>> CACHE_KEY_DICT = Maps.newHashMap();

    public String getDictLabel(String value, String type, String defaultValue) {
        if (StringUtils.isNotBlank((CharSequence)type) && StringUtils.isNotBlank((CharSequence)value)) {
            Collection<Dict> list = this.dictMap().get(type.toUpperCase());
            for (Dict dict : list) {
                if (!value.equals(dict.getValue())) continue;
                return dict.getLabel();
            }
        }
        return defaultValue;
    }

    public String getDictLabelByLikeType(String value, String type, String defaultValue) {
        Dict dict;
        if (StringUtils.isNotBlank((CharSequence)type) && StringUtils.isNotBlank((CharSequence)value) && (dict = this.getDictByLikeType(value, type)) != null) {
            return dict.getLabel();
        }
        return defaultValue;
    }

    public Collection<Dict> getDictList(String type) {
        return this.dictMap().get(type.toUpperCase());
    }

    public Map<String, String> getDictMap(String type) {
        Collection<Dict> list = this.dictMap().get(type.toUpperCase());
        HashMap<String, String> map = new HashMap<String, String>();
        for (Dict dict : list) {
            map.put(dict.getValue(), dict.getLabel());
        }
        return map;
    }

    private Map<String, Collection<Dict>> dictMap() {
        if (MapUtil.isNotEmpty(this.CACHE_KEY_DICT)) {
            return this.CACHE_KEY_DICT;
        }
        List dictList = this.dictDao.selectDictList();
        ArrayListMultimap map = ArrayListMultimap.create();
        for (Dict dict : dictList) {
            map.put((Object)dict.getType().toUpperCase(), (Object)dict);
        }
        this.CACHE_KEY_DICT = map.asMap();
        return this.CACHE_KEY_DICT;
    }

    public String getDictListJson(String type) {
        return JsonMapper.toJsonString(this.getDictList(type.toUpperCase()));
    }

    public List<Dict> getDictListByLikeType(String type) {
        ArrayList dictList = Lists.newArrayList();
        Set<String> keyset = this.CACHE_KEY_DICT.keySet();
        for (String key : keyset) {
            if (!key.startsWith(type)) continue;
            dictList.addAll(this.CACHE_KEY_DICT.get(key));
        }
        return dictList;
    }

    public Dict getDictByLikeType(String data, String type) {
        List<Dict> dictList = this.getDictListByLikeType(type);
        for (Dict dict : dictList) {
            if (!Objects.equals(dict.getValue(), data)) continue;
            return dict;
        }
        return null;
    }
}

