/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.sys;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.domain.Dict;
import com.bcxin.risk.common.domain.MarketRegion;
import com.bcxin.risk.common.domain.Region;
import com.bcxin.risk.common.util.ConfigUtil;
import com.bcxin.risk.report.material.domain.MaterialFormOption;
import com.bcxin.risk.spring.SpringContextHolder;
import com.bcxin.risk.sys.SysDictUtil;
import com.bcxin.risk.sys.SysMarketRegionUtil;
import com.bcxin.risk.sys.SysMaterialOptionUtil;
import com.bcxin.risk.sys.SysRegionUtil;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysBasicUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysBasicUtil.class);
    private static SysDictUtil sysDictUtil = SpringContextHolder.getBean(SysDictUtil.class);
    private static SysRegionUtil sysRegionUtil = SpringContextHolder.getBean(SysRegionUtil.class);
    private static SysMaterialOptionUtil sysMaterialOptionUtil = SpringContextHolder.getBean(SysMaterialOptionUtil.class);
    private static SysMarketRegionUtil sysMarketRegionUtil = SpringContextHolder.getBean(SysMarketRegionUtil.class);

    public static String getDictLabel(String value, String type, String defaultValue) {
        return sysDictUtil.getDictLabel(value, type, defaultValue);
    }

    public static String getDictLabelByLikeType(String value, String type, String defaultValue) {
        return sysDictUtil.getDictLabelByLikeType(value, type, defaultValue);
    }

    public static String getDictValue(String label, String type, String defaultLabel) {
        return sysDictUtil.getDictLabel(label, type, defaultLabel);
    }

    public static Collection<Dict> getDictList(String type) {
        return sysDictUtil.getDictList(type);
    }

    public static String getDictListJson(String type) {
        return sysDictUtil.getDictListJson(type);
    }

    public static String getOptionLabel(String value, String type, String defaultValue) {
        return sysMaterialOptionUtil.getOptionLabel(value, type, defaultValue);
    }

    public static Collection<MaterialFormOption> getOptionList(String type) {
        return sysMaterialOptionUtil.getOptionList(type);
    }

    public static String getConfig(String key) {
        return ConfigUtil.getValue(key);
    }

    public static Region getRegionById(String id) {
        return sysRegionUtil.getRegionById(id);
    }

    public static String getProvinceRegionNameById(String id) {
        Region region = sysRegionUtil.getProvinceRegionById(id);
        if (region != null && StringUtil.isNotEmpty((String)region.getProvince())) {
            return region.getProvince();
        }
        return "";
    }

    public static String getRegionNameById(String id) {
        Region region = sysRegionUtil.getRegionById(id);
        String name = "";
        if (region != null) {
            if (StringUtil.isNotEmpty((String)region.getProvince())) {
                name = region.getProvince();
            } else if (StringUtil.isNotEmpty((String)region.getCity())) {
                name = region.getCity();
            } else if (StringUtil.isNotEmpty((String)region.getArea())) {
                name = region.getArea();
            }
        }
        return name;
    }

    public static String getMarketRegionNameById(Long id) {
        MarketRegion region = sysMarketRegionUtil.getBlazerMarket(id);
        if (id == Long.parseLong("100000")) {
            return "\u5168\u56fd";
        }
        return StringUtil.isEmpty((String)region.getProvince()) ? region.getCity() : region.getProvince();
    }

    public static List findMarketRegionByIndependent() {
        return sysMarketRegionUtil.findRegionByIndependent();
    }
}

