/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.enums.OperateLogTypeEnum;
import com.bcxin.risk.log.OperateLog;
import com.bcxin.risk.log.OperateLogDao;
import com.bcxin.risk.order.OrderForm;
import com.bcxin.risk.order.OrderFormDao;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.concurrent.Future;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LogUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogUtil.class);
    @Autowired
    OperateLogDao operateLogDao;
    @Autowired
    OrderFormDao orderFormDao;

    @Async
    public void saveOperateLog(String ip, Long userId, String bizId, OperateLogTypeEnum typeEnum, String content, String success) {
        OrderForm orderForm = this.orderFormDao.findOrderFormByOid(Long.valueOf(Long.parseLong(bizId)));
        OperateLog operateLog = new OperateLog();
        operateLog.setIp(ip);
        operateLog.setUserId(userId);
        operateLog.setContent(typeEnum.getAlias());
        operateLog.setOperateType(typeEnum.getKey());
        operateLog.setBizId(orderForm.getOrderNo());
        operateLog.setActivityId(orderForm.getActivity().getOid());
        operateLog.setActivityName(orderForm.getActivity().getName());
        operateLog.setOperateTime(new Date());
        operateLog.setCreateOn(new Date());
        operateLog.setUpdateOn(new Date());
        operateLog.setContent(content);
        operateLog.setSuccess(success);
        this.saveOperateLog(operateLog);
    }

    @Async
    public void saveOperateLog(String ip, Long userId, OperateLogTypeEnum typeEnum, String exceptionMsg) {
        OperateLog operateLog = new OperateLog();
        operateLog.setIp(ip);
        operateLog.setUserId(userId);
        operateLog.setContent(typeEnum.getAlias());
        operateLog.setOperateType(typeEnum.getKey());
        operateLog.setOperateTime(new Date());
        operateLog.setCreateOn(new Date());
        operateLog.setUpdateOn(new Date());
        operateLog.setSuccess("1");
        if (StringUtil.isNotEmpty((String)exceptionMsg)) {
            operateLog.setSuccess("0");
            operateLog.setException(exceptionMsg);
        }
        this.saveOperateLog(operateLog);
    }

    @Async
    public void saveOperateLog(String ip, Long userId, OperateLogTypeEnum typeEnum, Exception e) {
        this.saveOperateLog(ip, userId, typeEnum.getAlias(), typeEnum, e);
    }

    @Async
    public void saveOperateLog(String ip, Long userId, String content, OperateLogTypeEnum typeEnum, Exception e) {
        this.saveOperateLog(ip, userId, content, typeEnum, null, null, e);
    }

    @Async
    public void saveOperateLog(String ip, Long userId, String content, OperateLogTypeEnum typeEnum, Long orderId, Exception e) {
        OrderForm orderForm = this.orderFormDao.findOrderFormByOid(orderId);
        OperateLog operateLog = new OperateLog();
        operateLog.setIp(ip);
        operateLog.setUserId(userId);
        operateLog.setContent(content);
        operateLog.setOperateType(typeEnum.getKey());
        operateLog.setBizId(orderForm.getOrderNo());
        operateLog.setSourceId(orderForm.getOrderNo());
        operateLog.setActivityId(orderForm.getActivity().getOid());
        operateLog.setActivityName(orderForm.getActivity().getName());
        operateLog.setOperateTime(new Date());
        operateLog.setCreateOn(new Date());
        operateLog.setUpdateOn(new Date());
        operateLog.setSuccess("1");
        if (e != null) {
            operateLog.setSuccess("0");
            operateLog.setException(this.getStackMessage(e));
        }
        this.saveOperateLog(operateLog);
    }

    @Async
    public void saveOperateLog(String ip, Long userId, String content, OperateLogTypeEnum typeEnum, String bizId, String sourceId, Exception e) {
        OperateLog operateLog = new OperateLog();
        operateLog.setIp(ip);
        operateLog.setUserId(userId);
        operateLog.setContent(content);
        operateLog.setOperateType(typeEnum.getKey());
        operateLog.setBizId(bizId);
        operateLog.setSourceId(sourceId);
        operateLog.setOperateTime(new Date());
        operateLog.setCreateOn(new Date());
        operateLog.setUpdateOn(new Date());
        operateLog.setSuccess("1");
        if (e != null) {
            operateLog.setSuccess("0");
            operateLog.setException(this.getStackMessage(e));
        }
        this.saveOperateLog(operateLog);
    }

    @Async
    public Future<Boolean> saveOperateLog(OperateLog operateLog) {
        this.operateLogDao.save((Object)operateLog);
        return new AsyncResult((Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStackMessage(Exception e) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            String expMessage;
            e.printStackTrace(new PrintWriter(buf, true));
            String string = expMessage = buf.toString();
            return string;
        }
        catch (Exception ex) {
            String string = "";
            return string;
        }
        finally {
            try {
                buf.close();
            }
            catch (Exception exception) {}
        }
    }
}

