/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.dynamic;

import com.alibaba.fastjson.JSON;
import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.activity.ActivityCooperDao;
import com.bcxin.risk.activity.ActivityDao;
import com.bcxin.risk.activity.dto.data.ActivityCooperDTO;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.util.ConfigUtil;
import com.bcxin.risk.compose.draft.ComposeFile;
import com.bcxin.risk.compose.draft.ComposeFileDao;
import com.bcxin.risk.compose.draft.ComposeTask;
import com.bcxin.risk.compose.draft.ComposeTaskDao;
import com.bcxin.risk.dynamic.DynamicPanel;
import com.bcxin.risk.dynamic.DynamicPanelDao;
import com.bcxin.risk.dynamic.DynamicPanelTemplate;
import com.bcxin.risk.dynamic.DynamicPanelTemplateDao;
import com.bcxin.risk.dynamic.DynamicTemplateConst;
import com.bcxin.risk.dynamic.dto.DynamicActPanel;
import com.bcxin.risk.dynamic.dto.DynamicApprovePanel;
import com.bcxin.risk.dynamic.dto.DynamicFengPingPanel;
import com.bcxin.risk.dynamic.dto.DynamicOrderPanel;
import com.bcxin.risk.dynamic.dto.DynamicSurveyPanel;
import com.bcxin.risk.dynamic.dto.DynamicZhuanXiePanel;
import com.bcxin.risk.enums.DynamicPermissionEnum;
import com.bcxin.risk.enums.DynamicTypeEnum;
import com.bcxin.risk.order.OrderForm;
import com.bcxin.risk.order.OrderFormDao;
import com.bcxin.risk.order.Transaction;
import com.bcxin.risk.order.TransactionDao;
import com.bcxin.risk.org.domain.Org;
import com.bcxin.risk.report.domain.Report;
import com.bcxin.risk.report.material.dao.ReportDao;
import com.bcxin.risk.survey.SurveyExpertDao;
import com.bcxin.risk.survey.domain.Task;
import com.bcxin.risk.surveytk.TaskDao;
import com.bcxin.risk.user.dao.UserDao;
import com.bcxin.risk.user.domain.User;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DynamicUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicUtil.class);
    @Autowired
    DynamicPanelDao dynamicPanelDao;
    @Autowired
    ActivityDao activityDao;
    @Autowired
    DynamicPanelTemplateDao dynamicPanelTemplateDao;
    @Autowired
    ReportDao reportDao;
    @Autowired
    TransactionDao transactionDao;
    @Autowired
    ActivityCooperDao activityCooperDao;
    @Autowired
    OrderFormDao orderFormDao;
    @Autowired
    ComposeTaskDao composeTaskDao;
    @Autowired
    ComposeFileDao composeFileDao;
    @Autowired
    TaskDao taskDao;
    @Autowired
    SurveyExpertDao surveyExpertDao;
    @Autowired
    UserDao userDao;

    public boolean checkDynamic(Long templateId, Long userId, Long activityId) {
        return this.dynamicPanelDao.checkDynamic(templateId, userId, activityId);
    }

    @Async
    public void saveContractData(User operateUser, Activity activity, Long templateId, DynamicTypeEnum typeEnum) {
        OrderForm orderForm = this.orderFormDao.findOrderFormByAcivity(activity);
        this.saveData(operateUser, orderForm, templateId, typeEnum, DynamicPermissionEnum.DYNAMIC_CONTRACTOR);
    }

    @Async
    public void saveContractData(User operateUser, OrderForm orderForm, Long templateId, DynamicTypeEnum typeEnum) {
        this.saveData(operateUser, orderForm, templateId, typeEnum, DynamicPermissionEnum.DYNAMIC_CONTRACTOR);
    }

    @Async
    public void saveFPData(User operateUser, Activity activity, Long templateId, DynamicTypeEnum typeEnum) {
        OrderForm orderForm = this.orderFormDao.findOrderFormByAcivity(activity);
        if (templateId.toString().equals("200002")) {
            typeEnum = DynamicTypeEnum.DYNAMIC_ORDER;
        }
        this.saveFPData(operateUser, orderForm, templateId, typeEnum);
    }

    @Async
    public void saveFPData(User operateUser, Long orderId, Long templateId, DynamicTypeEnum typeEnum) {
        OrderForm orderForm = this.orderFormDao.findOrderFormByOid(orderId);
        this.saveFPData(operateUser, orderForm, templateId, typeEnum);
    }

    @Async
    public void saveFPData(User operateUser, OrderForm orderForm, Long templateId, DynamicTypeEnum typeEnum) {
        this.saveData(operateUser, orderForm, templateId, typeEnum, DynamicPermissionEnum.DYNAMIC_FENGPING);
    }

    @Async
    public void saveFPReportData(User operateUser, Long templateId, Long reportId, String reportFile, String reportType, String reSubmit) {
        String[] tmp;
        Report report = (Report)this.reportDao.selectById(reportId);
        if (report == null) {
            return;
        }
        Activity activity = report.getActivity();
        List orgList = this.activityCooperDao.findActivityCooperDtoByActivty(activity);
        Org org = this.getPGOrg(orgList);
        Long contractOrgId = activity.getOrg().getOid();
        DynamicPanel panel = new DynamicPanel();
        if (templateId.equals(DynamicTemplateConst.DYNAMIC_TEMP_FENGPING_200003)) {
            panel.setOrgId(org.getOid());
        } else if (templateId.equals(DynamicTemplateConst.DYNAMIC_TEMP_FENGPING_200004)) {
            panel.setContractOrgId(contractOrgId);
        } else {
            panel.setOrgId(org.getOid());
        }
        panel.setActivityId(activity.getOid());
        panel.setActivityName(activity.getName());
        if (templateId.toString().equals("200003")) {
            panel.setDynamicType(DynamicTypeEnum.DYNAMIC_ORDER.getKey());
        } else {
            panel.setDynamicType(DynamicTypeEnum.DYNAMIC_FENGPING.getKey());
        }
        if (operateUser != null) {
            panel.setOperateId(operateUser.getOid());
            panel.setOperateType(operateUser.getUserType());
            panel.setOperateName(operateUser.getRealName());
        }
        panel.setDynamicPermission(DynamicPermissionEnum.DYNAMIC_FENGPING.getKey());
        panel.setDynamicPanelTemplate((DynamicPanelTemplate)this.dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());
        if (StringUtil.isEmpty((String)reportType) && (tmp = reportFile.split("\\|\\|")) != null && tmp.length > 1) {
            reportFile = ConfigUtil.getValue("web_url") + tmp[1];
        }
        DynamicFengPingPanel fpPanel = new DynamicFengPingPanel(operateUser, org, activity, reportFile, reportType);
        fpPanel.setReSubmit(reSubmit);
        panel.setTemplateData(JSON.toJSONString((Object)fpPanel));
        this.dynamicPanelDao.saveOrUpdate((Object)panel);
    }

    @Async
    public void saveData(User operateUser, OrderForm orderForm, Long templateId, DynamicTypeEnum typeEnum, DynamicPermissionEnum permissionEnum) {
        List orgList = this.activityCooperDao.findActivityCooperDtoByActivty(orderForm.getActivity());
        Activity activity = orderForm.getActivity();
        Long contractOrgId = activity.getOrg().getOid();
        Long orgId = this.getPingGuOrg(orgList);
        DynamicPanel panel = new DynamicPanel();
        if (permissionEnum == DynamicPermissionEnum.DYNAMIC_FENGPING) {
            panel.setOrgId(orgId);
        } else if (permissionEnum == DynamicPermissionEnum.DYNAMIC_CONTRACTOR) {
            panel.setContractOrgId(contractOrgId);
        } else {
            panel.setOrgId(orgId);
            panel.setContractOrgId(contractOrgId);
        }
        panel.setActivityId(activity.getOid());
        panel.setActivityName(activity.getName());
        panel.setDynamicType(typeEnum.getKey());
        if (operateUser != null) {
            panel.setOperateId(operateUser.getOid());
            panel.setOperateType(operateUser.getUserType());
            panel.setOperateName(operateUser.getRealName());
        }
        panel.setDynamicPermission(permissionEnum.getKey());
        panel.setDynamicPanelTemplate((DynamicPanelTemplate)this.dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());
        panel.setTemplateData(JSON.toJSONString((Object)this.transferData(typeEnum, operateUser, orderForm, orgList)));
        this.dynamicPanelDao.saveOrUpdate((Object)panel);
    }

    @Async
    public void saveZXData(User operateUser, Long templateId, Report report, ComposeTask composeTask) {
        Activity activity = report.getActivity();
        List orgList = this.activityCooperDao.findActivityCooperDtoByActivty(activity);
        ComposeFile composeFile = null;
        if (composeTask != null) {
            composeFile = this.composeFileDao.findByReportAndTask(report.getOid().longValue(), composeTask.getOid());
        }
        Long orgId = this.getPingGuOrg(orgList);
        DynamicPanel panel = new DynamicPanel();
        panel.setOrgId(orgId);
        panel.setActivityId(activity.getOid());
        panel.setActivityName(activity.getName());
        panel.setDynamicType(DynamicTypeEnum.DYNAMIC_ZHUANXIE.getKey());
        if (operateUser != null) {
            panel.setOperateId(operateUser.getOid());
            panel.setOperateType(operateUser.getUserType());
            panel.setOperateName(operateUser.getRealName());
        }
        panel.setDynamicPermission(DynamicPermissionEnum.DYNAMIC_FENGPING.getKey());
        panel.setDynamicPanelTemplate((DynamicPanelTemplate)this.dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());
        panel.setTemplateData(JSON.toJSONString((Object)this.transferZXData(operateUser, report, composeFile, orgList)));
        this.dynamicPanelDao.saveOrUpdate((Object)panel);
    }

    public Object transferZXData(User operateUser, Report report, ComposeFile composeFile, List<ActivityCooperDTO> orgList) {
        DynamicZhuanXiePanel object = null;
        Org pgOrg = this.getPGOrg(orgList);
        List composeTaskList = this.composeTaskDao.findByActivity(report.getActivity());
        object = new DynamicZhuanXiePanel(operateUser, report, composeFile, pgOrg, composeTaskList);
        return object;
    }

    @Async
    public void saveTKData(User operateUser, Long templateId, Long taskId, User tkUser) {
        this.saveTKData(operateUser, templateId, taskId, tkUser, DynamicPermissionEnum.DYNAMIC_ALL);
    }

    @Async
    public void saveTKData(User operateUser, Long templateId, Long taskId, User tkUser, DynamicPermissionEnum permissionEnum) {
        Task task = (Task)this.taskDao.selectById(taskId);
        this.saveTKData(operateUser, templateId, task, tkUser, permissionEnum);
    }

    @Async
    public void saveSuggestTKData(User operateUser, Activity activity, Long templateId, String suggest, String photos, String step, DynamicPermissionEnum permissionEnum) {
        List orgList = this.activityCooperDao.findActivityCooperDtoByActivty(activity);
        Long orgId = this.getPingGuOrg(orgList);
        Long contractId = activity.getOrg().getOid();
        DynamicPanel panel = new DynamicPanel();
        if (permissionEnum == DynamicPermissionEnum.DYNAMIC_FENGPING) {
            panel.setOrgId(orgId);
        } else if (permissionEnum == DynamicPermissionEnum.DYNAMIC_CONTRACTOR) {
            panel.setContractOrgId(contractId);
        } else {
            panel.setContractOrgId(contractId);
            panel.setOrgId(orgId);
        }
        panel.setActivityId(activity.getOid());
        panel.setActivityName(activity.getName());
        panel.setDynamicType(DynamicTypeEnum.DYNAMIC_KANCHA.getKey());
        if (operateUser != null) {
            panel.setOperateId(operateUser.getOid());
            panel.setOperateType(operateUser.getUserType());
            panel.setOperateName(operateUser.getRealName());
        }
        panel.setDynamicPermission(permissionEnum.getKey());
        panel.setDynamicPanelTemplate((DynamicPanelTemplate)this.dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());
        panel.setTemplateData(JSON.toJSONString((Object)new DynamicSurveyPanel(operateUser, activity, suggest, photos, step)));
        this.dynamicPanelDao.saveOrUpdate((Object)panel);
    }

    @Async
    public void saveTKData(User operateUser, Long templateId, Task task, User tkUser, DynamicPermissionEnum permissionEnum) {
        Activity activity = task.getActivity();
        String tkzjUserList = this.surveyExpertDao.findSurveyExperts(task.getOid());
        List orgList = this.activityCooperDao.findActivityCooperDtoByActivty(activity);
        Long orgId = this.getPingGuOrg(orgList);
        Long contractId = activity.getOrg().getOid();
        DynamicPanel panel = new DynamicPanel();
        if (permissionEnum == null) {
            permissionEnum = DynamicPermissionEnum.DYNAMIC_ALL;
        }
        if (permissionEnum == DynamicPermissionEnum.DYNAMIC_CONTRACTOR) {
            panel.setContractOrgId(contractId);
        } else if (permissionEnum == DynamicPermissionEnum.DYNAMIC_FENGPING) {
            panel.setOrgId(orgId);
        } else {
            panel.setContractOrgId(contractId);
            panel.setOrgId(orgId);
        }
        panel.setActivityId(activity.getOid());
        panel.setActivityName(activity.getName());
        panel.setDynamicType(DynamicTypeEnum.DYNAMIC_KANCHA.getKey());
        if (operateUser != null) {
            panel.setOperateId(operateUser.getOid());
            panel.setOperateType(operateUser.getUserType());
            panel.setOperateName(operateUser.getRealName());
        }
        panel.setDynamicPermission(permissionEnum.getKey());
        panel.setDynamicPanelTemplate((DynamicPanelTemplate)this.dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());
        panel.setTemplateData(JSON.toJSONString((Object)new DynamicSurveyPanel(operateUser, task, tkUser, tkzjUserList)));
        this.dynamicPanelDao.saveOrUpdate((Object)panel);
    }

    @Async
    public void saveTKExpertData(User operateUser, Long templateId, Long taskId, String expertId) {
        Task task = (Task)this.taskDao.selectById(taskId);
        DynamicPermissionEnum permissionEnum = DynamicPermissionEnum.DYNAMIC_ALL;
        Activity activity = task.getActivity();
        String tkzjUserList = "";
        User user = (User)this.userDao.selectById(Long.valueOf(Long.parseLong(expertId.split("#")[0])));
        if (user != null) {
            tkzjUserList = user.getRealName() + " " + user.getPhone();
        }
        List orgList = this.activityCooperDao.findActivityCooperDtoByActivty(activity);
        Long orgId = this.getPingGuOrg(orgList);
        Long contractId = activity.getOrg().getOid();
        DynamicPanel panel = new DynamicPanel();
        panel.setContractOrgId(contractId);
        panel.setOrgId(orgId);
        panel.setActivityId(activity.getOid());
        panel.setActivityName(activity.getName());
        panel.setDynamicType(DynamicTypeEnum.DYNAMIC_KANCHA.getKey());
        if (operateUser != null) {
            panel.setOperateId(operateUser.getOid());
            panel.setOperateType(operateUser.getUserType());
            panel.setOperateName(operateUser.getRealName());
        }
        panel.setDynamicPermission(permissionEnum.getKey());
        panel.setDynamicPanelTemplate((DynamicPanelTemplate)this.dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());
        panel.setTemplateData(JSON.toJSONString((Object)new DynamicSurveyPanel(operateUser, task, null, tkzjUserList)));
        this.dynamicPanelDao.saveOrUpdate((Object)panel);
    }

    @Async
    public void saveDynamicActPanel(Long userId, Long activityId, String activityName, Long templateId) {
        User user = this.userDao.findUserByOid(userId.longValue());
        if (user == null) {
            return;
        }
        DynamicActPanel actPanel = new DynamicActPanel(user, activityId + "", activityName);
        DynamicPanel panel = new DynamicPanel();
        if (user != null) {
            panel.setOperateId(user.getOid());
            panel.setOperateType(user.getUserType());
            panel.setOperateName(user.getRealName());
            panel.setContractOrgId(user.getOrg().getOid());
        }
        panel.setActivityId(activityId);
        panel.setActivityName(activityName);
        panel.setDynamicType(DynamicTypeEnum.DYNAMIC_ACTIVITY.getKey());
        panel.setDynamicPermission(DynamicPermissionEnum.DYNAMIC_CONTRACTOR.getKey());
        panel.setDynamicPanelTemplate((DynamicPanelTemplate)this.dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());
        panel.setTemplateData(JSON.toJSONString((Object)actPanel));
        this.dynamicPanelDao.saveOrUpdate((Object)panel);
    }

    @Async
    public void saveDynamicApprovePanel(Long activityId, Long templateId) {
        Activity activity = this.activityDao.findActivityByOid(activityId);
        User user = activity.getUser();
        if (user == null) {
            return;
        }
        this.saveDynamicApprovePanel(activity, templateId, null, null, null);
    }

    @Async
    public void saveTransferPanel(Long activityId, String transferArea, String transferContent) {
        Activity activity = this.activityDao.findActivityByOid(activityId);
        User user = activity.getUser();
        if (user == null) {
            return;
        }
        Long templateId = DynamicTemplateConst.DYNAMIC_TEMP_APPROVE_600012;
        this.saveDynamicApprovePanel(activity, templateId, null, transferArea, transferContent);
    }

    public void saveApprovePanel(Activity activity, String sbApproveStatus, String content) {
        User user = activity.getUser();
        if (user == null) {
            return;
        }
        Long templateId = null;
        if (Objects.equals(sbApproveStatus, "20")) {
            templateId = DynamicTemplateConst.DYNAMIC_TEMP_APPROVE_600003;
        } else if (Objects.equals(sbApproveStatus, "30")) {
            templateId = DynamicTemplateConst.DYNAMIC_TEMP_APPROVE_600002;
        } else if (Objects.equals(sbApproveStatus, "SL20")) {
            templateId = DynamicTemplateConst.DYNAMIC_TEMP_APPROVE_600007;
        } else if (Objects.equals(sbApproveStatus, "SL30")) {
            templateId = DynamicTemplateConst.DYNAMIC_TEMP_APPROVE_600006;
        } else if (Objects.equals(sbApproveStatus, "2")) {
            templateId = DynamicTemplateConst.DYNAMIC_TEMP_APPROVE_600009;
        } else if (Objects.equals(sbApproveStatus, "3")) {
            templateId = DynamicTemplateConst.DYNAMIC_TEMP_APPROVE_600010;
        } else if (Objects.equals(sbApproveStatus, "4")) {
            templateId = DynamicTemplateConst.DYNAMIC_TEMP_APPROVE_600008;
        }
        if (templateId == null) {
            return;
        }
        this.saveDynamicApprovePanel(activity, templateId, content, null, null);
    }

    public void saveDynamicApprovePanel(Activity activity, Long templateId, String approveContent, String transferArea, String transferContent) {
        User user = activity.getUser();
        if (user == null) {
            return;
        }
        DynamicApprovePanel approvePanel = new DynamicApprovePanel();
        approvePanel.setActivityId(activity.getOid() + "");
        approvePanel.setActivityName(activity.getName());
        approvePanel.setUserName(user.getUserName());
        approvePanel.setOperateId(user.getOid() + "");
        approvePanel.setOperateName(user.getRealName());
        approvePanel.setTransferArea(transferArea);
        approvePanel.setTransferContent(transferContent);
        approvePanel.setApproveContent(approveContent);
        DynamicPanel panel = new DynamicPanel();
        if (user != null) {
            panel.setOperateId(user.getOid());
            panel.setOperateType(user.getUserType());
            panel.setOperateName(user.getRealName());
            panel.setContractOrgId(user.getOrg().getOid());
        }
        panel.setActivityId(activity.getOid());
        panel.setActivityName(activity.getName());
        panel.setDynamicType(DynamicTypeEnum.DYNAMIC_APPROVE.getKey());
        panel.setDynamicPermission(DynamicPermissionEnum.DYNAMIC_CONTRACTOR.getKey());
        panel.setDynamicPanelTemplate((DynamicPanelTemplate)this.dynamicPanelTemplateDao.selectById(templateId));
        panel.setCreateOn(new Date());
        panel.setUpdateOn(new Date());
        panel.setTemplateData(JSON.toJSONString((Object)approvePanel));
        this.dynamicPanelDao.saveOrUpdate((Object)panel);
    }

    public void updateDynamicLogShowStatus(Long activityId, String showStatus) {
        this.dynamicPanelDao.updateDynamicShowStatus(activityId, showStatus);
    }

    @Async
    public void saveDynamicActUpdateLog(Long activityId) {
        Activity activity = this.activityDao.findActivityByOid(activityId);
        this.saveDynamicActUpdateLogFP(activity);
        this.saveDynamicActUpdateLogContractor(activity);
    }

    public void saveDynamicActUpdateLogFP(Activity activity) {
        List orgList = this.activityCooperDao.findActivityCooperDtoByActivty(activity);
        Org org = this.getPGOrg(orgList);
        if (org == null) {
            return;
        }
        String dynamicOid = "";
        if (StringUtil.isEmpty((String)dynamicOid)) {
            DynamicPanel dynamicPanel = new DynamicPanel();
            dynamicPanel.setOrgId(org.getOid());
            dynamicPanel.setUpdateOn(new Date());
            dynamicPanel.setCreateOn(new Date());
            dynamicPanel.setActivityId(activity.getOid());
            dynamicPanel.setActivityName(activity.getName());
            dynamicPanel.setDynamicPanelTemplate((DynamicPanelTemplate)this.dynamicPanelTemplateDao.selectById(DynamicTemplateConst.DYNAMIC_TEMP_ORDER_100006));
            dynamicPanel.setDynamicPermission(DynamicPermissionEnum.DYNAMIC_FENGPING.getKey());
            dynamicPanel.setDynamicType(DynamicTypeEnum.DYNAMIC_ORDER.getKey());
            DynamicFengPingPanel fpPanel = new DynamicFengPingPanel();
            fpPanel.setContractName(activity.getSponsor());
            fpPanel.setActivityId(activity.getOid() + "");
            fpPanel.setActivityName(activity.getName());
            dynamicPanel.setTemplateData(JSON.toJSONString((Object)fpPanel));
            dynamicPanel.setIsShow("1");
            this.dynamicPanelDao.saveOrUpdate((Object)dynamicPanel);
        } else {
            DynamicPanel panel = (DynamicPanel)this.dynamicPanelDao.selectById(Long.valueOf(Long.parseLong(dynamicOid)));
            this.dynamicPanelDao.saveOrUpdate((Object)panel);
        }
    }

    public void saveDynamicActUpdateLogContractor(Activity activity) {
        Org org = activity.getOrg();
        String dynamicOid = "";
        if (StringUtil.isEmpty((String)dynamicOid)) {
            DynamicPanel dynamicPanel = new DynamicPanel();
            dynamicPanel.setContractOrgId(org.getOid());
            dynamicPanel.setUpdateOn(new Date());
            dynamicPanel.setCreateOn(new Date());
            dynamicPanel.setActivityId(activity.getOid());
            dynamicPanel.setActivityName(activity.getName());
            dynamicPanel.setDynamicPanelTemplate((DynamicPanelTemplate)this.dynamicPanelTemplateDao.selectById(DynamicTemplateConst.DYNAMIC_TEMP_ACTIVITY_500003));
            dynamicPanel.setDynamicPermission(DynamicPermissionEnum.DYNAMIC_CONTRACTOR.getKey());
            dynamicPanel.setDynamicType(DynamicTypeEnum.DYNAMIC_ACTIVITY.getKey());
            DynamicFengPingPanel fpPanel = new DynamicFengPingPanel();
            fpPanel.setContractName(activity.getSponsor());
            fpPanel.setActivityId(activity.getOid() + "");
            fpPanel.setActivityName(activity.getName());
            fpPanel.setOperateId(activity.getUser().getOid().toString());
            fpPanel.setOperateName(activity.getUser().getUserName());
            dynamicPanel.setTemplateData(JSON.toJSONString((Object)fpPanel));
            dynamicPanel.setIsShow("1");
            this.dynamicPanelDao.saveOrUpdate((Object)dynamicPanel);
        } else {
            DynamicPanel panel = (DynamicPanel)this.dynamicPanelDao.selectById(Long.valueOf(Long.parseLong(dynamicOid)));
            panel.setCreateOn(new Date());
            panel.setUpdateOn(new Date());
            this.dynamicPanelDao.saveOrUpdate((Object)panel);
        }
    }

    public Object transferData(DynamicTypeEnum typeEnum, User operateUser, OrderForm orderForm, List<ActivityCooperDTO> orgList) {
        DynamicFengPingPanel object = null;
        Report report = this.reportDao.findReportByActivity(orderForm.getActivity());
        Transaction transaction = this.transactionDao.findTransactionByOrder(orderForm);
        Org pgOrg = this.getPGOrg(orgList);
        switch (typeEnum) {
            case DYNAMIC_ORDER: {
                object = new DynamicOrderPanel(operateUser, orderForm, transaction, report, orgList);
                break;
            }
            case DYNAMIC_FENGPING: {
                object = new DynamicFengPingPanel(operateUser, orderForm, report, pgOrg);
                break;
            }
            case DYNAMIC_ZHUANXIE: {
                break;
            }
            case DYNAMIC_KANCHA: {
                break;
            }
        }
        return object;
    }

    public Long getPingGuOrg(List<ActivityCooperDTO> orgList) {
        if (orgList != null) {
            for (ActivityCooperDTO dto : orgList) {
                if (!Objects.equals(dto.getServiceOrgType(), "1")) continue;
                return Long.parseLong(dto.getOid());
            }
        }
        return null;
    }

    public Org getPGOrg(List<ActivityCooperDTO> orgList) {
        Org org = new Org();
        if (orgList != null) {
            for (ActivityCooperDTO dto : orgList) {
                if (!Objects.equals(dto.getServiceOrgType(), "1")) continue;
                org.setOid(Long.valueOf(Long.parseLong(dto.getOid())));
                org.setName(dto.getName());
                return org;
            }
        }
        return null;
    }

    private DynamicTypeEnum getDynamicType(Long templateId) {
        String key = templateId.toString().substring(0, 3);
        for (DynamicTypeEnum typeEnum : DynamicTypeEnum.values()) {
            if (!typeEnum.getKey().equals(key)) continue;
            return typeEnum;
        }
        return null;
    }
}

