/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;

public class ImageUtil {
    public static void zoomImageScale(File imageFile, String newPath, int newWidth) throws IOException {
        if (!imageFile.canRead()) {
            return;
        }
        BufferedImage bufferedImage = ImageIO.read(imageFile);
        if (null == bufferedImage) {
            return;
        }
        int originalWidth = bufferedImage.getWidth();
        int originalHeight = bufferedImage.getHeight();
        double scale = (double)originalWidth / (double)newWidth;
        int newHeight = (int)((double)originalHeight / scale);
        ImageUtil.zoomImageUtils(imageFile, newPath, bufferedImage, newWidth, newHeight);
    }

    private static void zoomImageUtils(File imageFile, String newPath, BufferedImage bufferedImage, int width, int height) throws IOException {
        String suffix = StringUtils.substringAfterLast((String)imageFile.getName(), (String)".");
        if (suffix != null && (suffix.trim().toLowerCase().endsWith("png") || suffix.trim().toLowerCase().endsWith("gif"))) {
            BufferedImage to = new BufferedImage(width, height, 1);
            Graphics2D g2d = to.createGraphics();
            to = g2d.getDeviceConfiguration().createCompatibleImage(width, height, 3);
            g2d.dispose();
            g2d = to.createGraphics();
            Image from = bufferedImage.getScaledInstance(width, height, 16);
            g2d.drawImage(from, 0, 0, null);
            g2d.dispose();
            ImageIO.write((RenderedImage)to, suffix, new File(newPath));
        } else {
            BufferedImage newImage = new BufferedImage(width, height, bufferedImage.getType());
            Graphics g = newImage.getGraphics();
            g.drawImage(bufferedImage, 0, 0, width, height, null);
            g.dispose();
            ImageIO.write((RenderedImage)newImage, suffix, new File(newPath));
        }
    }

    public static int[] getImagePixels(File imageFile) {
        try {
            BufferedImage bi = ImageIO.read(imageFile);
            int width = bi.getWidth();
            int height = bi.getHeight();
            int[] ints = new int[]{width, height};
            return ints;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new int[]{0, 0};
        }
    }
}

