/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.cache.redis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Service;

@Service
public class RedisUtil {
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Resource
    private HashOperations<String, String, Object> hashOperations;
    @Resource
    private ValueOperations<String, Object> valueOperations;
    @Resource
    private ListOperations<String, Object> listOperations;
    @Resource
    private SetOperations<String, Object> setOperations;
    @Resource
    private ZSetOperations<String, Object> zSetOperations;

    public boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public boolean hasKey(String key, String hashKey) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)hashKey);
    }

    public void expire(String key, long timeout, TimeUnit unit) {
        this.redisTemplate.expire((Object)key, timeout, unit);
    }

    public long ttl(String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    public Set<String> keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public void delete(Set<String> keys) {
        this.redisTemplate.delete(keys);
    }

    private void setExpire(String key, long expire) {
        if (expire != -1L) {
            this.redisTemplate.expire((Object)key, expire, TimeUnit.SECONDS);
        }
    }

    public void addValue(String key, Object value, long expire) {
        this.valueOperations.set((Object)key, value, expire, TimeUnit.SECONDS);
    }

    public void addValue(String key, Object value, long expire, TimeUnit timeUnit) {
        this.valueOperations.set((Object)key, value, expire, timeUnit);
    }

    public void addValue(String key, Object value) {
        this.valueOperations.set((Object)key, value);
    }

    public Object getValue(String key) {
        return this.valueOperations.get((Object)key);
    }

    public void addHashValue(String key, String hashKey, Object data, long expire) {
        this.hashOperations.put((Object)key, (Object)hashKey, data);
        this.setExpire(key, expire);
    }

    public void addAllHashValue(String key, Map<String, Object> map, long expire) {
        this.hashOperations.putAll((Object)key, map);
        this.setExpire(key, expire);
    }

    public long deleteHashValue(String key, String hashKey) {
        return this.hashOperations.delete((Object)key, new Object[]{hashKey});
    }

    public Object getHashValue(String key, String hashKey) {
        return this.hashOperations.get((Object)key, (Object)hashKey);
    }

    public List<Object> getHashAllValue(String key) {
        return this.hashOperations.values((Object)key);
    }

    public List<Object> getHashMultiValue(String key, List<String> hashKeys) {
        return this.hashOperations.multiGet((Object)key, hashKeys);
    }

    public Long getHashCount(String key) {
        return this.hashOperations.size((Object)key);
    }

    public Map<String, Object> getHash(String key) {
        return this.hashOperations.entries((Object)key);
    }

    public boolean addZSetValue(String key, Object member, long score) {
        return this.zSetOperations.add((Object)key, member, (double)score);
    }

    public boolean addZSetValue(String key, Object member, double score) {
        return this.zSetOperations.add((Object)key, member, score);
    }

    public long addBatchZSetValue(String key, Set<ZSetOperations.TypedTuple<Object>> tuples) {
        return this.zSetOperations.add((Object)key, tuples);
    }

    public void incZSetValue(String key, String member, long delta) {
        this.zSetOperations.incrementScore((Object)key, (Object)member, (double)delta);
    }

    public long getZSetScore(String key, String member) {
        Double score = this.zSetOperations.score((Object)key, (Object)member);
        if (score == null) {
            return 0L;
        }
        return score.longValue();
    }

    public Set<ZSetOperations.TypedTuple<Object>> getZSetRank(String key, long start, long end) {
        return this.zSetOperations.rangeWithScores((Object)key, start, end);
    }

    public void addListValue(String key, Object list, long expire) {
        this.listOperations.leftPush((Object)key, list);
        this.expire(key, expire, TimeUnit.SECONDS);
    }

    public Object getListValue(String key) {
        return this.listOperations.range((Object)key, 0L, -1L);
    }

    public void addSetValue(String key, Object list, long expire) {
        this.setOperations.add((Object)key, new Object[]{list});
        this.expire(key, expire, TimeUnit.SECONDS);
    }

    public Object getSetValue(String key) {
        Set obj = this.setOperations.members((Object)key);
        if (obj instanceof Set && obj.isEmpty()) {
            return null;
        }
        return obj;
    }

    public Object popSetValue(String key) {
        return this.setOperations.pop((Object)key);
    }
}

