/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.activity;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.activity.dto.diff.ActivityDiffDTO;
import com.bcxin.risk.report.material.domain.MaterialFormModule;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ActivityUtil {
    public static List<ActivityDiffDTO> compareDiffActivity(Activity newInfo, Activity oldInfo) {
        ArrayList<ActivityDiffDTO> diffDTOList = new ArrayList<ActivityDiffDTO>();
        if (oldInfo == null) {
            return diffDTOList;
        }
        Field[] fs = newInfo.getClass().getDeclaredFields();
        for (int i = 0; i < fs.length; ++i) {
            Field f = fs[i];
            String newVal = "";
            String oldVal = "";
            try {
                newVal = f.get(newInfo) != null ? f.get(newInfo).toString() : "";
                String string = oldVal = f.get(oldInfo) != null ? f.get(oldInfo).toString() : "";
                if (Objects.equals(newVal, oldVal)) continue;
                ActivityDiffDTO diffDTO = new ActivityDiffDTO();
                diffDTO.setKey(f.getName());
                diffDTO.setNewValue(newVal);
                diffDTO.setOldValue(oldVal);
                diffDTOList.add(diffDTO);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return diffDTOList;
    }

    public static List<ActivityDiffDTO> compareDiffModuleActivity(List<MaterialFormModule> list, Map<String, String> map) {
        ArrayList<ActivityDiffDTO> diffDTOList = new ArrayList<ActivityDiffDTO>();
        for (MaterialFormModule module : list) {
            String moduleType = module.getMaterialModule();
            String oldValue = module.getValue();
            if (Objects.equals(oldValue, map.get(moduleType))) continue;
            ActivityDiffDTO diffDTO = new ActivityDiffDTO();
            diffDTO.setKey(moduleType);
            diffDTO.setNewValue(map.get(moduleType));
            diffDTO.setOldValue(oldValue);
            diffDTOList.add(diffDTO);
        }
        return diffDTOList;
    }

    public static boolean validMaterialModuleChange(List<MaterialFormModule> list, Map<String, String> map) {
        boolean changeFlag = false;
        if (list == null || list.isEmpty()) {
            return true;
        }
        for (MaterialFormModule module : list) {
            String moduleType = module.getMaterialModule();
            String value = module.getValue();
            if (Objects.equals(value, map.get(moduleType))) continue;
            changeFlag = true;
            break;
        }
        return changeFlag;
    }
}

