/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.log;

import com.bcxin.risk.common.util.DateUtil;
import com.bcxin.risk.log.ChangeLog;
import com.google.common.collect.Lists;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompareUtil.class);

    public static String compareObj(Object obj1, Object obj2) {
        StringBuilder sb = new StringBuilder();
        try {
            Class<?> clazz = obj1.getClass();
            Method[] methods = clazz.getMethods();
            ArrayList textList = Lists.newArrayList();
            for (int i = 0; i < methods.length; ++i) {
                String s2;
                Method method = methods[i];
                String name = StringUtils.uncapitalize((String)method.getName().replace("get", "").trim());
                if (!method.getName().startsWith("get")) continue;
                Object o1 = method.invoke(obj1, new Object[0]);
                Object o2 = method.invoke(obj2, new Object[0]);
                String s1 = o1 == null ? "" : o1.toString();
                String string = s2 = o2 == null ? "" : o2.toString();
                if (s1.equals(s2)) continue;
                sb.append(name).append(",");
            }
        }
        catch (Exception e) {
            log.error("CompareUtil\u6bd4\u8f83\u5c5e\u6027\u5f02\u5e38{}", (Throwable)e);
        }
        String name = "";
        if (sb.length() > 0) {
            name = sb.substring(0, sb.length() - 1);
        }
        return name;
    }

    public static List<ChangeLog> compareChangeObject(Long marketRegionId, Object oldObj, Object newObj) throws IntrospectionException {
        PropertyDescriptor[] pds;
        BeanInfo beanInfo;
        ArrayList<ChangeLog> list = new ArrayList<ChangeLog>();
        try {
            beanInfo = Introspector.getBeanInfo(oldObj.getClass());
        }
        catch (IntrospectionException e1) {
            throw new IntrospectionException("\u83b7\u53d6class\u7c7b\u5f02\u5e38");
        }
        for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
            String name = pd.getName();
            try {
                Object oldVal = pd.getReadMethod().invoke(oldObj, new Object[0]);
                Object newVal = pd.getReadMethod().invoke(newObj, new Object[0]);
                boolean b = CompareUtil.compareTwo(oldVal, newVal);
                if (b) continue;
                ChangeLog changeLog = new ChangeLog(marketRegionId, "PSS", name, oldVal, newVal);
                list.add(changeLog);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalArgumentException("\u83b7\u53d6\u5c5e\u6027\u503c\u5f02\u5e38", e);
            }
        }
        return list;
    }

    public static String compareObject(Object obj1, Object obj2) throws IntrospectionException {
        PropertyDescriptor[] pds;
        BeanInfo beanInfo;
        StringBuilder sb = new StringBuilder();
        try {
            beanInfo = Introspector.getBeanInfo(obj1.getClass());
        }
        catch (IntrospectionException e1) {
            throw new IntrospectionException("\u83b7\u53d6class\u7c7b\u5f02\u5e38");
        }
        for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
            String name = pd.getName();
            try {
                Object value1 = pd.getReadMethod().invoke(obj1, new Object[0]);
                Object value2 = pd.getReadMethod().invoke(obj2, new Object[0]);
                boolean b = CompareUtil.compareTwo(value1, value2);
                if (b) continue;
                sb.append(name).append(",");
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalArgumentException("\u83b7\u53d6\u5c5e\u6027\u503c\u5f02\u5e38", e);
            }
        }
        String name = "";
        if (sb.length() > 0) {
            name = sb.substring(0, sb.length() - 1);
        }
        return name;
    }

    public static Map<String, String> compareObjReturnMap(Object obj1, Object obj2) {
        LinkedHashMap<String, String> sameMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> differMap = new LinkedHashMap<String, String>();
        try {
            Class<?> clazz = obj1.getClass();
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                String s3;
                Method method = methods[i];
                String name = StringUtils.uncapitalize((String)method.getName().replace("get", "").trim());
                if (!method.getName().startsWith("get")) continue;
                Object o1 = method.invoke(obj1, new Object[0]);
                Object o2 = method.invoke(obj2, new Object[0]);
                String s1 = o1 == null ? "" : o1.toString();
                String s2 = o2 == null ? "" : o2.toString();
                String className = "";
                if (o1 != null) {
                    className = o1.getClass().getName();
                }
                if (o2 != null) {
                    className = o2.getClass().getName();
                }
                if (!s1.equals(s2)) {
                    if (className.equals("java.util.Date")) {
                        s3 = "";
                        if (StringUtils.isNotBlank((CharSequence)s1)) {
                            s3 = DateUtil.getFormat(s1);
                        }
                        String s4 = "";
                        if (StringUtils.isNotBlank((CharSequence)s2)) {
                            s4 = DateUtil.getFormat(s2);
                        }
                        differMap.put(name, s3 + "|" + s4);
                        continue;
                    }
                    differMap.put(name, s1 + "|" + s2);
                    continue;
                }
                if (className.equals("java.util.Date")) {
                    s3 = "";
                    if (StringUtils.isNotBlank((CharSequence)s1)) {
                        s3 = DateUtil.getFormat(s1);
                    }
                    sameMap.put(name, s3);
                    continue;
                }
                sameMap.put(name, s1);
            }
        }
        catch (Exception e) {
            log.error("CompareUtil\u6bd4\u8f83\u5c5e\u6027\u5f02\u5e38{}", (Throwable)e);
        }
        if (differMap.size() > 0) {
            sameMap.putAll(differMap);
        } else {
            sameMap.clear();
        }
        return sameMap;
    }

    public static Map<String, String> compareObjReturnMap1(Object obj1, Object obj2) throws IntrospectionException, ParseException {
        BeanInfo beanInfo;
        LinkedHashMap<String, String> differMap = new LinkedHashMap<String, String>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd Hh:mm:ss");
        try {
            beanInfo = Introspector.getBeanInfo(obj1.getClass());
        }
        catch (IntrospectionException e1) {
            throw new IntrospectionException("\u83b7\u53d6class\u7c7b\u5f02\u5e38");
        }
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        boolean isDiffer = false;
        for (PropertyDescriptor pd : pds) {
            String name = pd.getName();
            Class<?> type = pd.getPropertyType();
            try {
                boolean b;
                Object value1 = pd.getReadMethod().invoke(obj1, new Object[0]);
                Object value2 = pd.getReadMethod().invoke(obj2, new Object[0]);
                if (type.equals(Date.class)) {
                    if (value1 != null && StringUtils.isNotBlank((CharSequence)value1.toString())) {
                        value1 = df.format(value1);
                    }
                    if (value2 != null && StringUtils.isNotBlank((CharSequence)value2.toString())) {
                        value2 = df.format(value2);
                    }
                }
                if (!(b = CompareUtil.compareObject(differMap, name, value1, value2))) continue;
                isDiffer = true;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalArgumentException("\u83b7\u53d6\u5c5e\u6027\u503c\u5f02\u5e38", e);
            }
        }
        if (!isDiffer) {
            differMap.clear();
        }
        return differMap;
    }

    private static boolean compareObject(Map<String, String> differMap, String name, Object value1, Object value2) {
        boolean isDiffer = false;
        boolean b = CompareUtil.compareTwo(value1, value2);
        if (!b) {
            isDiffer = true;
            differMap.put(name, value1 + " <> " + value2);
        } else {
            differMap.put(name, value1 + " = " + value2);
        }
        return isDiffer;
    }

    public static boolean compareTwo(Object object1, Object object2) {
        if (object1 == null && object2 == null) {
            return true;
        }
        if (object1 == null && object2 != null) {
            return false;
        }
        return object1.equals(object2);
    }
}

