/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util.cipher;

import com.bcxin.risk.support.security.BASE64Encoder;
import com.bcxin.risk.support.security.coder.DESCoder;
import com.bcxin.risk.support.security.coder.HmacCoder;
import com.bcxin.risk.support.security.coder.MDCoder;
import com.bcxin.risk.support.security.coder.RSACoder;
import com.bcxin.risk.support.security.coder.SHACoder;
import java.util.Map;

public final class SecurityUtil {
    private static final byte[] ENCRYPT_KEY = new byte[]{-81, 0, 105, 7, -32, 26, -49, 88};
    public static final String CHARSET = "UTF-8";

    private SecurityUtil() {
    }

    public static final byte[] decryptBASE64(String key) {
        try {
            return new BASE64Encoder().decode(key);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", e);
        }
    }

    public static final String encryptBASE64(byte[] key) {
        try {
            return new BASE64Encoder().encode(key);
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", e);
        }
    }

    public static final String decryptDes(String cryptData) {
        return SecurityUtil.decryptDes(cryptData, ENCRYPT_KEY);
    }

    public static final String encryptDes(String data) {
        return SecurityUtil.encryptDes(data, ENCRYPT_KEY);
    }

    public static final String encryptMd5(String strSrc) {
        String outString = null;
        try {
            outString = SecurityUtil.encryptBASE64(MDCoder.encodeMD5(strSrc.getBytes(CHARSET)));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", e);
        }
        return outString;
    }

    public static final String encryptSHA(String data) {
        try {
            return SecurityUtil.encryptBASE64(SHACoder.encodeSHA256(data.getBytes(CHARSET)));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", e);
        }
    }

    public static final String encryptHMAC(String data) {
        return SecurityUtil.encryptHMAC(data, ENCRYPT_KEY);
    }

    public static final String decryptDes(String cryptData, byte[] key) {
        String decryptedData = null;
        try {
            decryptedData = new String(DESCoder.decrypt(SecurityUtil.decryptBASE64(cryptData), key));
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", e);
        }
        return decryptedData;
    }

    public static final String encryptDes(String data, byte[] key) {
        String encryptedData = null;
        try {
            encryptedData = SecurityUtil.encryptBASE64(DESCoder.encrypt(data.getBytes(), key));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", e);
        }
        return encryptedData;
    }

    public static final String encryptHMAC(String data, byte[] key) {
        try {
            return SecurityUtil.encryptBASE64(HmacCoder.encodeHmacSHA512(data.getBytes(CHARSET), key));
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u5bc6\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", e);
        }
    }

    public static final String signRSA(String data, String privateKey) {
        try {
            return SecurityUtil.encryptBASE64(RSACoder.sign(data.getBytes(CHARSET), SecurityUtil.decryptBASE64(privateKey)));
        }
        catch (Exception e) {
            throw new RuntimeException("\u7b7e\u540d\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", e);
        }
    }

    public static final boolean verifyRSA(String data, String publicKey, String sign) {
        try {
            return RSACoder.verify(data.getBytes(CHARSET), SecurityUtil.decryptBASE64(publicKey), SecurityUtil.decryptBASE64(sign));
        }
        catch (Exception e) {
            throw new RuntimeException("\u9a8c\u7b7e\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", e);
        }
    }

    public static final String encryptRSAPrivate(String data, String privateKey) {
        try {
            return SecurityUtil.encryptBASE64(RSACoder.encryptByPrivateKey(data.getBytes(CHARSET), SecurityUtil.decryptBASE64(privateKey)));
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", e);
        }
    }

    public static final String decryptRSAPublic(String cryptData, String publicKey) {
        try {
            return new String(RSACoder.decryptByPublicKey(SecurityUtil.decryptBASE64(cryptData), SecurityUtil.decryptBASE64(publicKey)));
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u5bc6\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a", e);
        }
    }

    public static String encryptPassword(String password) {
        return SecurityUtil.encryptMd5(SecurityUtil.encryptSHA(password));
    }

    public static void main(String[] args) throws Exception {
        System.out.println(SecurityUtil.encryptDes("SHJR"));
        System.out.println(SecurityUtil.decryptDes("INzvw/3Qc4q="));
        System.out.println(SecurityUtil.encryptMd5("SHJR"));
        System.out.println(SecurityUtil.encryptSHA("1"));
        Map<String, Object> key = RSACoder.initKey();
        String privateKey = SecurityUtil.encryptBASE64(RSACoder.getPrivateKey(key));
        String publicKey = SecurityUtil.encryptBASE64(RSACoder.getPublicKey(key));
        System.out.println(privateKey);
        System.out.println(publicKey);
        String sign = SecurityUtil.signRSA("132", privateKey);
        System.out.println(sign);
        String encrypt = SecurityUtil.encryptRSAPrivate("132", privateKey);
        System.out.println(encrypt);
        String org = SecurityUtil.decryptRSAPublic(encrypt, publicKey);
        System.out.println(org);
        System.out.println(SecurityUtil.verifyRSA(org, publicKey, sign));
    }
}

