/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class CookieUtil {
    private CookieUtil() {
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        if (maxAge > 0) {
            cookie.setMaxAge(maxAge);
        }
        response.addCookie(cookie);
    }

    public static void removeCookie(HttpServletResponse response, String name) {
        Cookie uid = new Cookie(name, null);
        uid.setPath("/");
        uid.setMaxAge(0);
        response.addCookie(uid);
    }

    public static String getUid(HttpServletRequest request, String cookieName) {
        Cookie[] cookies;
        for (Cookie cookie : cookies = request.getCookies()) {
            if (!cookie.getName().equals(cookieName)) continue;
            return cookie.getValue();
        }
        return null;
    }
}

