/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util;

import com.google.common.base.Stopwatch;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BcxinHttpUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BcxinHttpUtil.class);

    public static String sendPostRequest(String url, List<NameValuePair> params) {
        log.debug("--------\u5f00\u59cb\u53d1\u9001http\u8bf7\u6c42--------");
        log.debug("\u8bf7\u6c42\u5730\u5740:[{}]\uff1a", (Object)url);
        BcxinHttpUtil.logParams(params);
        Stopwatch stopwatch = Stopwatch.createStarted();
        String result = "";
        if (url.startsWith("https")) {
            try (CloseableHttpClient httpClient = BcxinHttpUtil.createSSLClientDefault();){
                HttpPost httpPost = new HttpPost(url);
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
                RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).build();
                httpPost.setConfig(defaultRequestConfig);
                try (CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)httpPost);){
                    HttpEntity entity = resp.getEntity();
                    result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                    long nanos = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                    log.debug("\u8fd4\u56de\u7ed3\u679c\uff1a[{}]", (Object)result);
                    log.debug("\u5171\u8017\u65f6[{}]\u6beb\u79d2\uff1a", (Object)nanos);
                    log.debug("--------\u7ed3\u675fhttp\u8bf7\u6c42--------");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                HttpPost httpPost = new HttpPost(url);
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
                RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).build();
                httpPost.setConfig(defaultRequestConfig);
                try (CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)httpPost);){
                    HttpEntity entity = resp.getEntity();
                    result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                    long nanos = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                    log.debug("\u8fd4\u56de\u7ed3\u679c\uff1a[{}]", (Object)result);
                    log.debug("\u5171\u8017\u65f6[{}]\u6beb\u79d2\uff1a", (Object)nanos);
                    log.debug("--------\u7ed3\u675fhttp\u8bf7\u6c42--------");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static Map<String, String> getAllRequestParam(HttpServletRequest request) {
        HashMap<String, String> res = new HashMap<String, String>();
        Enumeration temp = request.getParameterNames();
        if (null != temp) {
            while (temp.hasMoreElements()) {
                String en = (String)temp.nextElement();
                String value = request.getParameter(en);
                res.put(en, value);
                if (null != res.get(en) && !"".equals(res.get(en))) continue;
                res.remove(en);
            }
        }
        return res;
    }

    private static void logParams(List<NameValuePair> params) {
        for (NameValuePair pair : params) {
            log.debug("\u8bf7\u6c42\u7684\u53c2\u6570\u540d\uff1a[{}]\uff0c\u503c\uff1a[{}]", (Object)pair.getName(), (Object)pair.getValue());
        }
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static CloseableHttpClient createSSLClientDefault() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        return HttpClients.createDefault();
    }
}

