/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class BcxinDateUtil {
    private BcxinDateUtil() {
    }

    public static final String format(Object date) {
        return BcxinDateUtil.format(date, "yyyy-MM-dd");
    }

    public static boolean checkDate(String date) {
        String dateValue = BcxinDateUtil.marsalDate(date);
        return BcxinDateUtil.checkIsValidDateFormat(dateValue);
    }

    public static Date startOfTodDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date endOfTodDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static synchronized String generatorRadomNumber() {
        Date today = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        return format.format(today) + new DecimalFormat("0000").format(new Random().nextInt(10000));
    }

    public static String formatChinaDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm");
        return df.format(date);
    }

    public static String diffFormatChina(Date beginDate, Date endDate) {
        long min = DateUtil.between((Date)beginDate, (Date)endDate, (DateUnit)DateUnit.MINUTE);
        long day = min / 1440L;
        long hour = (min - day * 1440L) / 60L;
        long mins = min - (day * 1440L + hour * 60L);
        return day + "\u5929" + hour + "\u5c0f\u65f6" + mins + "\u5206";
    }

    public static final String format(Object date, String pattern) {
        if (date == null) {
            return null;
        }
        if (pattern == null) {
            return BcxinDateUtil.format(date);
        }
        return new SimpleDateFormat(pattern).format(date);
    }

    public static boolean checkIsValidDateFormat(String date) {
        if (date == null) {
            return false;
        }
        if (date.length() != 10) {
            return false;
        }
        String regex = "((\\d{2}(([02468][048])|([13579][26]))[\\-\\s]?((((0?[13578])|(1[02]))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\s]?((((0?[13578])|(1[02]))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))";
        Pattern pattern = Pattern.compile(regex);
        Matcher mather = pattern.matcher(date);
        return mather.matches();
    }

    public static String marsalDate(String year, String month, String day) {
        if (year.length() != 4 || month.length() > 2 || day.length() > 2) {
            return null;
        }
        String yearTemp = year;
        String monthTemp = month.length() == 1 ? "0" + month : month;
        String dayTemp = day.length() == 1 ? "0" + day : day;
        String date = yearTemp + "-" + monthTemp + "-" + dayTemp;
        return date;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String marsalDate(String date) {
        String day;
        String month;
        String year;
        date = date.replace("\u5e74", "-").replace("\u6708", "-").replace("\u65e5", "");
        String split = "./-\t\\s";
        if (date.length() > 10) return null;
        StringTokenizer tokenizer = new StringTokenizer(date, split);
        int tokenCount = tokenizer.countTokens();
        if (tokenCount == 3) {
            year = tokenizer.nextToken();
            month = tokenizer.nextToken();
            day = tokenizer.nextToken();
            return BcxinDateUtil.marsalDate(year, month, day);
        } else {
            if (tokenCount != 1) return null;
            String dateTemp = tokenizer.nextToken();
            if (dateTemp.length() == 8) {
                year = dateTemp.substring(0, 4);
                month = dateTemp.substring(4, 6);
                day = dateTemp.substring(6, 8);
                return BcxinDateUtil.marsalDate(year, month, day);
            } else {
                if (dateTemp.length() != 6) return null;
                year = dateTemp.substring(0, 4);
                month = dateTemp.substring(4, 5);
                day = dateTemp.substring(5, 6);
            }
        }
        return BcxinDateUtil.marsalDate(year, month, day);
    }

    public static int getLastDayOfMonth(String date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        formatter.format(formatter.parse(date));
        Calendar c = formatter.getCalendar();
        int day = c.getActualMaximum(5);
        return day;
    }

    public static interface DATE_PATTERN {
        public static final String HHMMSS = "HHmmss";
        public static final String HH_MM_SS = "HH:mm:ss";
        public static final String YYYYMMDD = "yyyyMMdd";
        public static final String YYYY_MM_DD = "yyyy-MM-dd";
        public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
        public static final String YYYYMMDDHHMMSSSSS = "yyyyMMddHHmmssSSS";
        public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    }
}

