package com.bcxin.risk.user.dao.impl;

import cn.hutool.core.util.ObjectUtil;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.expert.dto.ExpertPublicDto;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.log.dto.search.OperateLogDto;
import com.bcxin.risk.user.dao.ExpertUserDao;
import com.bcxin.risk.user.domain.ExpertUser;
import com.bcxin.risk.user.dto.search.ExpertUserSearchDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author hzp
 * 专家用户DAO实现层
 */
@Repository("expertUserDao")
@SuppressWarnings("unchecked")
public class ExpertUserDaoImpl extends DaoImpl<ExpertUser> implements ExpertUserDao {

    /**
     * 根据主键ID获取专家用户实体
     * @param oid 主键ID（用户ID）
     * @return
     */
    @Override
    public ExpertUser findExpertUserByOid(Long oid){
        return selectById(oid);
    }

    /**
     * 根据用户名获取专家用户实体
     * @param name 用户名
     * @return
     */
    @Override
    public ExpertUser findUserByName(String name) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("userName", name));
        List list = selectList(criterionList);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return (ExpertUser)list.get(0);
    }

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    @Override
    public List findExpertUserList(ExpertUserSearchDto searchDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql="SELECT " +
                " u.oid," +
                " u.realName," +
                " u.userName," +
                " u.phone," +
                " u.active," +
                " e.source," +
                " e.expertCategory," +
                " u.userType," +
                " e.jobLiveAddr," +
                " professional," +
                " p.label as professionalName," +
                " e.expertSource," +
                " e. LEVEL," +
                " e.taskQuote," +
                " o.name AS orgName," +
                " DATE_FORMAT(u.createOn,'%Y-%m-%d %H:%i:%s') AS createOn " +
                " FROM" +
                " risk_se_user u" +
                " inner join risk_expertuser e on u.oid=e.oid AND e.checkStatus ="+DictConst.CHECKSTATUS_PASS +
                " left join risk_org o on o.oid=e.serviceOrg_id " +
                " left join (select value,label from sys_dict t where t.type='PROFESSIONTYPE') p on p.value=e.professional "+
                " where 1=1 ";

        if (StringUtil.isNotEmpty(searchDto.getName() )){
            sql += " and u.realName LIKE '%"+searchDto.getName() +"%' " ;
        }
        if(StringUtil.isNotEmpty(searchDto.getKeyName())){
            sql += " and (" +
                    "u.realName LIKE '%"+searchDto.getKeyName() +"%' " +
                    "or u.userName LIKE '%"+searchDto.getKeyName() +"%' " +
                    "or u.phone like '%"+searchDto.getKeyName()+"%'" +
                    "or o.name like '%"+searchDto.getKeyName()+"%'" +
                    "or p.label like '%"+searchDto.getKeyName()+"%'" +
                    ")" ;
        }
        if (StringUtil.isNotEmpty(searchDto.getLevel() )){
            sql += " and e.level='"+ searchDto.getLevel() +"'";
        }
        if (StringUtil.isNotEmpty(searchDto.getUserType() )){
            sql += " and u.userType='"+ searchDto.getUserType() +"'";
        }
        if (StringUtil.isNotEmpty(searchDto.getExpertSource() )){
            sql += " and e.expertSource='"+ searchDto.getExpertSource() +"'";
        }
        if (StringUtil.isNotEmpty(searchDto.getActive() )){
            sql += " and u.active='"+ searchDto.getActive() +"'";
        }
        if(page!= null ){
            page.setTotalCount(querySqlCounts( sql,  wrapper));
            sql = sql + " ORDER BY u.updateOn DESC limit "+(page.getPageNum() - 1) * page.getNumPerPage()+","+page.getNumPerPage();
        }
        return  queryMaps( sql,  wrapper);

    }


    /**
     * 获取专家用户ID集合
     * @return
     */
    @Override
    public List<String> findComposeExpertUserId() {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "select eu.oid from RISK_ExpertUser eu " +
                    " inner join risk_se_user u on u.oid= eu.oid " +
                    " where active =1 and (eu.expertTaskType = 2 or eu.expertTaskType = 3) " +
                    " ORDER BY u.oid" ;
        List<Map<String, Object>> result = queryMaps(sql, wrapper);
        List<String> lists = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty(result)) {
            for (Map<String, Object> map : result) {
                lists.add(map.get("oid").toString());
            }
        }
        return lists;
    }

    @Override
    public List<ExpertUser> findUserByOrgIdAndUserType(Long orgId, String userType,String status){
        List<Criterion> criterions = new ArrayList<Criterion>();
        criterions.add(Restrictions.eq("active", "1"));
        criterions.add(Restrictions.eq("userType", userType));
        criterions.add(Restrictions.eq("checkStatus", status));
        if(orgId != null) {
            criterions.add(Restrictions.eq("org.oid", orgId));
        }
        return this.selectList(criterions);
    }

    @Override
    public List<ExpertUser> findUserByOrgIdAndUserTypeAndKTType(Long orgId, String userType, String status, Collection<String> tkType){
        List<Criterion> criterions = new ArrayList<Criterion>();
        criterions.add(Restrictions.eq("active", "1"));
        criterions.add(Restrictions.eq("userType", userType));
        criterions.add(Restrictions.eq("checkStatus", status));
        if(tkType != null) {
            criterions.add(Restrictions.in("ktType", tkType));
        }else{
            return Lists.newArrayList();
        }
        if(orgId != null) {
            criterions.add(Restrictions.eq("org.oid", orgId));
        }
        return this.selectList(criterions);
    }


    @Override
    public List<ExpertPublicDto> findExpertPublicList(ExpertPublicDto dto, Page page){
        String sql="select " +
                " A.oid," +
                " B.realName," +
                " A.`level`," +
                " A.expertCategory," +
                " A.taskQuote," +
                " A.professional," +
                " A.jobLiveAddr," +
                " A.jobLiveAddrCode," +
                " C.label as professionalName" +
                " from" +
                " risk_expertuser A "+
                " inner join risk_se_user B on A.oid=B.oid " +
                " left JOIN (SELECT label,`value` FROM sys_dict t WHERE type = 'PROFESSIONTYPE') C on C.`value`=A.professional "+
                " where 1=1 ";

        if(StringUtil.isNotEmpty(dto.getExpertSource())){
            sql+=" and A.expertSource='"+dto.getExpertSource()+"' ";
        }
        if(StringUtil.isNotEmpty(dto.getUserType())){
            sql+=" and B.userType='"+dto.getUserType()+"' ";
        }
        if(ObjectUtil.equal(dto.getSelectAll(),DictConst.Y)){
        }else{
            sql+=" and A.jobLiveAddrCode like '"+dto.getSelectProvince()+"%' ";
        }
        if(StringUtil.isNotEmpty(dto.getKeyword())){
            sql+=" and (B.realName like '%"+dto.getKeyword()+"%' ";
            sql+=" or C.label like '%"+dto.getKeyword()+"%' ";
            sql+=" or A.jobLiveAddr like '%"+dto.getKeyword()+"%' ";
            sql+=" or A.expertCategory like '%"+dto.getKeyword()+"%') ";
        }
        sql+=" ORDER BY A.createOn desc";

        List<ExpertPublicDto> dtoList = Lists.newArrayList();
        SelectWrapper wrapper = SelectWrapper.instance();
        Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
        List<Map<String, Object>> list = pageList.getRecords();
        list.forEach(result -> {
            ExpertPublicDto publicDto = new ExpertPublicDto(result);
            publicDto.setPage(page);
            dtoList.add(publicDto);
        });
        return dtoList;
    }
}
