package com.bcxin.risk.user.dao.impl;


import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.user.dao.ExpertServiceInfoDao;
import com.bcxin.risk.user.domain.ExpertServiceInfo;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository("expertServiceInfoDao")

public class ExpertServiceInfoDaoImpl extends DaoImpl<ExpertServiceInfo> implements ExpertServiceInfoDao {

    /**
     * 获取当前轮次
     * @return
     */
    @Override
    public int currentRound(){
        String sql = "SELECT max(round) as round " +
                "  FROM risk_expertServiceInfo ";
        SelectWrapper wrapper = SelectWrapper.instance();
        List<Map<String, Object>> result = queryMaps(sql, wrapper);
        if (CollectionUtil.isNotEmpty(result)) {
            Map<String, Object> map = result.get(0);
            if (map.get("round") == null || "null".equals(map.get("round"))) {
                return 1;
            }
            return Integer.parseInt(map.get("round").toString());
        }
        return 1;
    }

    /**
     * 获取当前轮次已分配的专家
     * @return
     */
    @Override
    public List<String> currentRoundExperts(int round) {
        String sql = "SELECT expertId " +
                "  FROM risk_expertServiceInfo where round = "+round+"";
        SelectWrapper wrapper = SelectWrapper.instance();
        List<Map<String, Object>> result = queryMaps(sql, wrapper);
        List<String> lists = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty(result)) {
            for (Map<String, Object> map : result) {
                lists.add(map.get("expertId").toString());
            }
        }
        return lists;
    }

    @Override
    public ExpertServiceInfo findExpertServiceInfoByOid(long expertServiceInfoId) {
        return selectById(expertServiceInfoId);
    }

}
