package com.bcxin.risk.survey;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.activity.Venue;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.util.ObjectUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.survey.domain.Survey_Rectification;
import com.bcxin.risk.survey.domain.dto.serach.Survey_RectificationSerachDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Repository("surveyRectificationDao")
@SuppressWarnings("unchecked")
public class SurveyRectificationDaoImpl extends DaoImpl<Survey_Rectification> implements SurveyRectificationDao  {

	@Override
	public Survey_Rectification findSurveyRectificationByOid(long oid) {
		return selectById(oid);
	}
	
	@Override
	public List<Survey_Rectification> findSurveyRectificationByActivity(Activity activity,String surveyStep) {
		List<Criterion> criterionList = Lists.newArrayList();
		criterionList.add(Restrictions.eq("activity", activity));
		if (StringUtil.isNotEmpty(surveyStep)) {
			criterionList.add(Restrictions.eq("surveyStep", surveyStep));
		}
		Order order = Order.desc("oid");
		return selectList(criterionList,order);
	}
	
	
	@Override
	public Survey_Rectification findSurveyRectificationByActivity(Activity activity, String surveyStep, Venue venue) {
		List<Criterion> criterionList = Lists.newArrayList();
		criterionList.add(Restrictions.eq("activity", activity));
		if (StringUtil.isNotEmpty(surveyStep)) {
			criterionList.add(Restrictions.eq("surveyStep", surveyStep));
		}
		if ( venue != null ) {
			criterionList.add(Restrictions.eq("venue", venue));
		}
		Order order =Order.desc("oid");
		List<Survey_Rectification> list = selectList(criterionList,order);
		if ( CollectionUtil.isNotEmpty(list))
			return list.get(0);
		return null;
	}
     @Override
	 public Survey_Rectification findSurveyRectificationByOid(Long oid){
		  return selectById(oid);
	}
	@Override
	public List<Survey_Rectification> findSurveyRectificationList(Survey_RectificationSerachDto searchDto, Page page) {
		List<Criterion> criterionList = Lists.newArrayList();
		if ( searchDto.getActivity() != null ) {
			criterionList.add(Restrictions.eq("activity", searchDto.getActivity()));
		}
		if ( searchDto.getVenue() != null ) {
			criterionList.add(Restrictions.eq("venue", searchDto.getVenue()));
		}
		if (StringUtil.isNotEmpty(searchDto.getSurveyReport()) ) {
			criterionList.add(Restrictions.eq("surveyReport", searchDto.getSurveyReport()));
		}
		if (StringUtil.isNotEmpty(searchDto.getSurveyStep()) ) {
			criterionList.add(Restrictions.eq("surveyStep", searchDto.getSurveyStep()));
		}
		if ( page == null ) {
			return selectList(criterionList);
		}
		return selectPage(criterionList,page);
	}

	@Override
	public Survey_Rectification findSurveyRectificationByReport(Activity activity, String step, Venue address) {
		List<Criterion> criterions = new ArrayList<Criterion>();
		if ( activity != null ) {
			criterions.add(Restrictions.eq("activity", activity));
		}

		if ( step != null ) {
			criterions.add(Restrictions.eq("surveyStep", step));
		}
		if ( address != null ) {
			criterions.add(Restrictions.eq("venue", address));
		}
		List<Survey_Rectification> list = selectList(criterions);
		if ( CollectionUtil.isNotEmpty(list))
			return list.get(0);
		return null;
	}


	public List<String> findSelfSurvey(Activity activity,String step){
	 	String sql = "SELECT " +
				" reportPath " +
				"		FROM " +
				" risk_survey_questionnaire" +
				"	WHERE " +
				" feedBackId IN (" +
				" 			SELECT" +
				" 				oid" +
				" 				FROM" +
				" risk_survey_feedback" +
				" WHERE" +
				" taskId IN (" +
				" SELECT " +
				" oid " +
				" FROM " +
				" risk_surveytask " +
				" WHERE " +
				" activityId = " + activity.getOid() +
				" )" +
				" ) and surveyStep = '"+step+"'";

		List<Map<String, Object>> list = queryMaps(sql);
		List<String> result = Lists.newArrayList();
		for (Map<String, Object> map:list) {
			String path = ObjectUtil.safeTransfor(map.get("reportPath"));
			if (StringUtil.isNotEmpty(path)) {
				result.add(path);
			}
		}
		return result;
	}


}
