package com.bcxin.risk.report.material;

import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.report.material.dao.MaterialFormAttrTemplateDao;
import com.bcxin.risk.report.material.domain.MaterialFormAttrTemplate;
import com.bcxin.risk.report.material.domain.MaterialFormMenuTemplate;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

@Repository
public class MaterialFormAttrTemplateDaoImpl extends DaoImpl<MaterialFormAttrTemplate> implements MaterialFormAttrTemplateDao {

	@Override
	public List<MaterialFormAttrTemplate> findAll() {
		return selectList();
	}

	@Override
	public List<MaterialFormAttrTemplate> findByMenu(MaterialFormMenuTemplate menuTemplate) {
		return selectList(CriterionWrapper.instance().eq("materialFormMenuTemplate",menuTemplate));
	}

	@Override
	public List<MaterialFormAttrTemplate> findByMenu(Collection<MaterialFormMenuTemplate> menuTemplateList) {
		return selectList(Restrictions.in("materialFormMenuTemplate",menuTemplateList));
	}

	@Override
	public List<MaterialFormAttrTemplate> findByAttrs(List<String> attrCodeList) {
		List<Criterion> criterionList = Lists.newArrayList();
		criterionList.add(Restrictions.in("attrCode", attrCodeList));
		return selectList(criterionList);
	}
}
