package com.bcxin.risk.policy;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.policy.domain.InsurancePolicy;
import com.bcxin.risk.policy.domain.RoleInPolicy;
import com.bcxin.risk.policy.dto.search.RoleInPolicySerachDto;
import com.bcxin.risk.policy.enums.RoleKind;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

/**
 * @return
 * @auther Administrator
 * @date 2017/04/24 0024
 * @注意事项 </b>
 */

@Repository("roleInPolicyDao")
@SuppressWarnings("unchecked")

public class RoleInPolicyDaoImpl extends DaoImpl<RoleInPolicy> implements RoleInPolicyDao {
    public RoleInPolicy findRoleInPolicyByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<RoleInPolicy> findRoleInPolicyList(RoleInPolicySerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getInsurancePolicy()!= null ) {
            criterionList.add(Restrictions.eq("insurancePolicy", searchDto.getInsurancePolicy()));
        }
        if (StringUtil.isNotEmpty(searchDto.getFullName()) ) {
            criterionList.add(Restrictions.eq("readStatus", searchDto.getFullName()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }
    
    @Override
    public RoleInPolicy findRoleInPolicyByKind(RoleKind kind, InsurancePolicy policy) {
        List<Criterion> criterions = new ArrayList<Criterion>();
        List<Criterion> criterionList = Lists.newArrayList();
        if (policy != null) {
            criterionList.add(Restrictions.eq("insurancePolicy", policy));
        }
        criterionList.add(Restrictions.eq("roleKind", kind));
        List<RoleInPolicy> plist = selectList(criterionList);
        if (plist.size() > 0) {
            return plist.get(0);
        }
        return null;
    }
}
