package com.bcxin.risk.policy;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.policy.domain.AmountSpec;
import com.bcxin.risk.policy.dto.search.AmountSpecSerachDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @param
 * @return
 * @auther Administrator
 * @date 2017/04/24 0024
 * @注意事项 </b>
 */

@Repository("amountSpecDao")
@SuppressWarnings("unchecked")

public class AmountSpecDaoImpl extends DaoImpl<AmountSpec> implements AmountSpecDao {

    public AmountSpec findAmountSpecByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<AmountSpec> findAmountSpecList(AmountSpecSerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getDutySpec()!= null ) {
            criterionList.add(Restrictions.eq("dutySpec", searchDto.getDutySpec()));
        }
        if (StringUtil.isNotEmpty(searchDto.getDescription()) ) {
            criterionList.add(Restrictions.eq("description", searchDto.getDescription()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }
}
