package com.bcxin.risk.org;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.constant.TableConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.org.domain.ServiceOrg;
import com.bcxin.risk.org.domain.ServiceOrgDao;
import com.bcxin.risk.org.dto.ServiceOrgSearchDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


@Repository
public class ServiceOrgDaoImpl extends DaoImpl<ServiceOrg> implements ServiceOrgDao {

    @Resource
    private BaseDao baseDao;

    @Override
    public ServiceOrg findServiceOrgByOid(Long oid) {
        return selectById(oid);
    }

    @Override
    public List<Map<String, Object>> findServiceOrgList(ServiceOrgSearchDto searchDto, Page page) {
        String sql = "SELECT CONCAT(a.oid,'') oid," +
                "b.name," +
                "a.serviceOrgType," +
                "a.distributionOrg," +
                "a.contactName," +
                "a.contactPhone," +
                "a.contactAddress," +
                "a.experts," +
                "a.introduce," +
                "a.experience " +
                "FROM risk_serviceOrg a , risk_org b " +
                "WHERE a.oid  = b.oid ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (searchDto.getCity_id()!=null) {
            //默认条件是市级
            int level = 2;
            //通过id的规则判断是不是省编码
            if(String.valueOf(searchDto.getCity_id()).endsWith("0000")){
                level = 1;
            }
            sql = sql + " AND EXISTS (SELECT 1 FROM risk_org_region WHERE org_id = a.oid AND region_level = '"+level+"' AND region_id = " + searchDto.getCity_id() + ")";
        }
        if (StringUtil.isNotEmpty(searchDto.getName())) {
            sql = sql + " AND name like '%" + searchDto.getName() + "%' ";
        }
        if (StringUtil.isNotEmpty(searchDto.getServiceOrgType())) {
            sql = sql + " AND serviceOrgType = " + searchDto.getServiceOrgType();
        }
        sql = sql + " AND b.active = 1 ";
        return queryMaps(sql, wrapper);
    }

    // 查询营业执照待审核的服务机构
    @Override
    public List<ServiceOrg> findDshServiceOrgList(ServiceOrgSearchDto searchDto, DwzPage page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (searchDto != null) {
            if (StringUtil.isNotEmpty(searchDto.getName())) {
                criterionList.add(Restrictions.like("name", "%" + searchDto.getName() + "%"));
            }
            if (StringUtil.isNotEmpty(searchDto.getServiceOrgType())) {
                criterionList.add(Restrictions.eq("serviceOrgType", searchDto.getServiceOrgType()));
            }
        }
        criterionList.add(Restrictions.eq("approvalStatus", DictConst.APPROVALSTATUS_DSH));
        List<Order> orderList = new ArrayList<Order>();
        orderList.add(Order.desc("updateOn"));
        if (page == null) {
            return baseDao.findByCriterion(ServiceOrg.class, criterionList, orderList);
        }
        return baseDao.findByCriterionForPage(ServiceOrg.class, criterionList, page, orderList);
    }


    @Override
    public Map<String, String> countOrder(ServiceOrg org) {
        if (org == null) {
            return Maps.newHashMap();
        }

        StringBuilder sql = new StringBuilder("select "
                + " sum(case a.activityStatus when '" + DictConst.ACTIVITYSTATUS_HDJS + "' then 1 else 0 end) as endtotal,"
                + " sum(case a.activityStatus when '" + DictConst.ACTIVITYSTATUS_HDJS + "' then 0 else 1 end) as duringtotal"
                + " from " + TableConst.ACTIVITY_TABLE + " a  "
                + " inner join " + TableConst.ACTIVITYCOOPER_TABLE + " cp on cp.activity_id = a.oid "
                + " inner join " + TableConst.SERIVICEORG_TABLE + " org on cp.org_id = org.oid ");

        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("org.oid", org.getOid());
        wrapper.notIn("a.activitySource",Lists.newArrayList(DictConst.ACTIVITYSOURCE_XTLR));

        Map<String, String> countMap = Maps.newHashMap();
        Map<String, Object> result = queryMap(sql.toString(), wrapper);
        countMap.put("endtotal", result.get("endtotal") == null ? "0" : result.get("endtotal").toString());
        countMap.put("duringtotal", result.get("duringtotal") == null ? "0" : result.get("duringtotal").toString());
        return countMap;
    }

    @Override
    public List<Map<String, Object>> findServiceOrgByDtoForPage(ServiceOrgSearchDto dto, DwzPage page) {
        String sql = "SELECT DISTINCT " +
                "a.oid, " +
                "b. NAME as name, " +
                "a.serviceOrgType, " +
                "a.serviceMode, " +
                "a.distributionOrg, " +
                "a.contactName, " +
                "a.contactPhone, " +
                "a.contactAddress, " +
                "c.userName, " +
                "( " +
                "SELECT " +
                "province " +
                "FROM " +
                "sys_region " +
                "WHERE " +
                "oid = b.province_id " +
                ") AS province, " +
                "( " +
                "SELECT " +
                "city " +
                "FROM " +
                "sys_region " +
                "WHERE " +
                "oid = b.city_id " +
                ") AS city, " +
                "( " +
                "SELECT " +
                "area " +
                "FROM " +
                "sys_region " +
                "WHERE " +
                "oid = b.area_id " +
                ") AS area " +
                "FROM " +
                "risk_serviceOrg a " +
                "INNER JOIN risk_org b ON a.oid = b.oid " +
                "LEFT JOIN risk_se_user c ON b.oid = c.org_id " +
                "AND c.userType = '5' " +
                "WHERE " +
                "1 = 1 ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (StringUtil.isNotEmpty(dto.getName())) {
            sql = sql + " AND name like '%" + dto.getName() + "%' ";
        }
        if (StringUtil.isNotEmpty(dto.getServiceOrgType())) {
            sql = sql + " AND serviceOrgType = " + dto.getServiceOrgType();
        }
        sql = sql + " ORDER BY a.oid DESC ";
        if (page != null) {
            page.setTotalCount(querySqlCounts(sql, wrapper));
            sql = sql + " limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        return queryMaps(sql, wrapper);
    }


    @Override
    public List<Map<String, Object>> findNeedSyncSPOrg() {
        String sql = "select  " +
                " so.oid as 'orgId', " +
                " so.serviceOrgType as 'orgType', " +
                " o.name as 'orgName', " +
                " so.introduce as 'orgIntroduce', " +
                " so.Experience as 'orgExperience', " +
                " so.Experts as 'orgExperts', " +
                " so.ContactName as 'orgContactName', " +
                " so.ContactPhone as 'orgContactPhone', " +
                " so.ContactAddress as 'orgContactAddress', " +
                " DATE_FORMAT(o.createOn,'%Y-%m-%d %H:%i:%s') as 'registerTime', " +
                " o.province_id as 'provinceId', " +
                " o.city_id as 'cityId' ," +
                " o.saasComId " +
                " from risk_serviceorg so " +
                " inner join risk_org o on so.oid = o.oid " +
                " where (so.syncSP = 0 or so.syncSP is null) and so.serviceOrgType = 1";
        SelectWrapper wrapper = SelectWrapper.instance();
        return queryMaps(sql, wrapper);
    }

}