package com.bcxin.risk.org;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.org.domain.InvoiceTemplate;
import com.bcxin.risk.org.domain.InvoiceTemplateDao;
import com.bcxin.risk.org.domain.Org;
import com.bcxin.risk.org.domain.PendOrg;
import com.bcxin.risk.org.dto.InvoiceDto;
import com.bcxin.risk.org.dto.InvoiceTemplateSerachDto;
import com.bcxin.risk.user.domain.User;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;


/**
 * @author Administrator
 */
@Repository("invoiceTemplateDao")
@SuppressWarnings("unchecked")

public class InvoiceTemplateDaoImpl extends DaoImpl<InvoiceTemplate> implements InvoiceTemplateDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public InvoiceTemplate findInvoiceTemplateByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<InvoiceTemplate> findInvoiceTemplateList(InvoiceTemplateSerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getOrg() != null ) {
            criterionList.add(Restrictions.eq("org", searchDto.getOrg()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }



    /**
     * 查询发票模板信息
     * @param org
     * @return
     */
    @Override
    public InvoiceTemplate findInvoiceCompanyByOrg(Org org) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("org",org));
        List<InvoiceTemplate> list = selectList(criterionList);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    /**
     * 普通发票
     * @param org
     * @return
     */
    @Override
    public InvoiceTemplate findActiveInvoiceByOrg(Org org) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("org",org));
        criterionList.add(Restrictions.eq("approveActive","1"));
        List<InvoiceTemplate> list = selectList(criterionList);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @SuppressWarnings("unchecked")
    @Override
    public List<InvoiceTemplate> findInvoiceCompany(DwzPage page, Org org, InvoiceDto invoiceDto) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (org != null) {
            criterionList.add(Restrictions.eq("org",org));
        }
        if(invoiceDto != null){
            if(StringUtil.isNotEmpty(invoiceDto.getCompanyName()))
                criterionList.add(Restrictions.eq("companyName",invoiceDto.getCompanyName()));
            if(StringUtil.isNotEmpty(invoiceDto.getBankAccount()))
                criterionList.add(Restrictions.eq("bankAccount",invoiceDto.getBankAccount()));
            if(StringUtil.isNotEmpty(invoiceDto.getRegisterAddress()))
                criterionList.add(Restrictions.eq("registerAddress",invoiceDto.getRegisterAddress()));
            if(StringUtil.isNotEmpty(invoiceDto.getTaxpayerNumber()))
                criterionList.add(Restrictions.eq("taxpayerNumber",invoiceDto.getTaxpayerNumber()));
            if(StringUtil.isNotEmpty(invoiceDto.getApproveActive()))
                criterionList.add(Restrictions.eq("approveActive",invoiceDto.getApproveActive()));
            if(StringUtil.isNotEmpty(invoiceDto.getInvoiceType())) {
                // 发票类型
                criterionList.add(Restrictions.eq("invoiceType", invoiceDto.getInvoiceType()));
            }
        }
        List<Order> orderList = new ArrayList<Order>();
        orderList.add(Order.desc("createOn"));
        if ( page == null ) {
            return baseDao.findByCriterion(InvoiceTemplate.class, criterionList,orderList);
        }
        return baseDao.findByCriterionForPage(InvoiceTemplate.class, criterionList, page,orderList);

    }

    @Override
    public InvoiceTemplate findInvoiceCompanyByOrg(Org org, InvoiceDto invoiceDto) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (org != null) {
            criterionList.add(Restrictions.eq("org",org));
        }
        if(invoiceDto!=null&&invoiceDto.getApproveActive()!=null){
            criterionList.add(Restrictions.eq("invoiceActive",invoiceDto.getApproveActive()));
        }
        List<InvoiceTemplate> list = selectList(criterionList);
        if(list.size()>0){
            return list.get(0);
        }
        return null;
    }

}
