package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.log.dto.search.SyLogSearchDTO;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository("sysLogDao")
@Transactional
public class SysLogDaoImpl extends DaoImpl<SysLog> implements SysLogDao {

    /**
     * 重写是否当前事务，将SysLogDao独立事务出来
     * @return
     */
    @Override
    protected Boolean isCurrent() {
        return Boolean.valueOf(false);
    }

    @Override
    public SysLog findSysLogByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<SysLog> findSysLogList(SyLogSearchDTO searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty(searchDto.getException()) ) {
            criterionList.add(Restrictions.eq("exception", searchDto.getException()));
        }
        if (StringUtil.isNotEmpty(searchDto.getLogType()) ) {
            criterionList.add(Restrictions.eq("logType", searchDto.getLogType()));
        }
        if (searchDto.getStartTime() != null ) {
            criterionList.add(Restrictions.ge("createOn", searchDto.getStartTime()));
        }
        if (searchDto.getEndTime() != null ) {
            criterionList.add(Restrictions.le("createOn", searchDto.getEndTime()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }
}
