package com.bcxin.risk.invitation;


import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.contractor.domain.Invitation;
import com.bcxin.risk.contractor.dto.InvitationSearchDto;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository("invatationDao")
public class InvitationDaoImpl extends DaoImpl<Invitation> implements InvitationDao {

	@Autowired
	private BaseDao baseDao;


    @Override
    public List<Invitation> findInvitationByDto(InvitationSearchDto searchDto) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty(searchDto.getCompanyName())) {
            criterionList.add(Restrictions.eq("companyName", searchDto.getCompanyName()));
        }
        if (StringUtil.isNotEmpty(searchDto.getCompanyType())) {
            criterionList.add(Restrictions.eq("companyType", searchDto.getCompanyType()));
        }
        if (StringUtil.isNotEmpty(searchDto.getFlag())) {
            criterionList.add(Restrictions.eq("flag", searchDto.getFlag()));
        }
        if (searchDto.getInviterId() != null && StringUtil.isNotEmpty(searchDto.getInviterId().toString())) {
            criterionList.add(Restrictions.eq("inviterId", searchDto.getInviterId()));
        }
        return selectList(criterionList);
    }
}
