package com.bcxin.risk.common.dao;

import com.bcxin.risk.activity.Venue;
import com.bcxin.risk.activity.dto.data.RepairDataDTO;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;


@Repository
public class RepairDaoImpl extends DaoImpl<Venue> implements RepairDao{

    @Override
    public List<RepairDataDTO> selectActivityMaterial() {
        String sql = "SELECT oid,'value' as columnName,'risk_activityMaterial' as tableName,value from risk_activitymaterial where createon > '2018-01-01'";
        SelectWrapper wrapper = SelectWrapper.instance();
        List<Map<String, Object>> list =  queryMaps( sql,  wrapper);
        List<RepairDataDTO> dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map<String, Object> map = (Map<String, Object>) result;
            RepairDataDTO dto = new RepairDataDTO(map);
            dtoList.add(dto);
        });
        return dtoList ;
    }

    @Override
    public List<RepairDataDTO> selectMaterialValue() {
        String sql = "SELECT a.oid,'value' as columnName,'risk_materialformvalue' as tableName,a.value from risk_materialformvalue a" +
                " inner join risk_materialformattr b on a.attr_id= b.oid where a.createon > '2018-01-01' and b.type in ('pic','file')";
        SelectWrapper wrapper = SelectWrapper.instance();
        List<Map<String, Object>> list =  queryMaps( sql,  wrapper);
        List<RepairDataDTO> dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map<String, Object> map = (Map<String, Object>) result;
            RepairDataDTO dto = new RepairDataDTO(map);
            dtoList.add(dto);
        });
        return dtoList ;
    }

    @Override
    public void update(RepairDataDTO dataDTO) {
        String sql = "update "+dataDTO.getTableName()+" set "+dataDTO.getColumnName()+" = '"+dataDTO.getNewValue()+"' where oid = "+dataDTO.getOid();
        executeSqlUpdate( sql);
    }

}
