package com.bcxin.risk.activity;

import com.bcxin.risk.activity.dto.search.ActivityRecordSearchDTO;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;


@Repository
public class ActivityRecordDaoImpl extends DaoImpl<ActivityRecord> implements ActivityRecordDao{

    @Override
    public ActivityRecord findActivityRecordByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<ActivityRecord> findActivityRecordList(ActivityRecordSearchDTO searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (searchDto.getActivity() != null) {
            criterionList.add(Restrictions.eq("activity",searchDto.getActivity()));
        }

        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }

    @Override
    public ActivityRecord findByStep(String activitySubStep, Activity activity) {

        List<Criterion> criterionList = Lists.newArrayList();
        if (activity != null) {
            criterionList.add(Restrictions.eq("activity",activity));
        }
        if (StringUtil.isNotEmpty(activitySubStep)) {
            criterionList.add(Restrictions.eq("activitySubStep",activitySubStep));
        }

        List<Object> list = selectList(criterionList);
        if ( CollectionUtil.isNotEmpty(list) ) {
            return (ActivityRecord)list.get(0);
        }
        return null;
    }

    @Override
    public void dateRecord(Activity activity, String activitysubstepDyjdtkywc) {
        List<Criterion> criterionList = Lists.newArrayList();
        int ActivitySubStep = 0;
        if (activity != null) {
            criterionList.add(Restrictions.eq("activity",activity));
        }
        List<ActivityRecord> list = selectList(criterionList);
        for (ActivityRecord activityRecord : list) {
            if (activityRecord.getActivitySubStep().equals(activitysubstepDyjdtkywc)){
                activityRecord.setUpdateOn(new Date());
                saveOrUpdate(activityRecord);
                ActivitySubStep = 1;
            }
        }
        if(ActivitySubStep == 0){
            ActivityRecord activityRecord = new ActivityRecord();
            int seq = Integer.parseInt(activitysubstepDyjdtkywc);
            activityRecord.setCreateOn(new Date());
            activityRecord.setActivity(activity);
            activityRecord.setActivitySubStep(activitysubstepDyjdtkywc);
            activityRecord.setSeq((seq-5)/5);
            save(activityRecord);
        }

    }

}
