package com.bcxin.risk.surveytk;

import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.survey.domain.SurveyAssist;
import com.bcxin.risk.surveytk.domain.dto.SurveyAssistDataDto;
import com.bcxin.risk.surveytk.domain.dto.SurveyAssistDto;

import java.util.List;

/**
 * @author hzp
 * 踏勘协助DAO层
 */
public interface SurveyTkAssistDao extends IDao<SurveyAssist> {

    /**
     * 根据主键id查找踏勘任务
     * @param oid
     * @return
     */
    SurveyAssist findSurveyAssistByOid(Long oid);

    /**
     * 查询踏勘任务列表
     * @param searchDto 查询对象
     * @param page
     * @return
     */
    List<SurveyAssistDataDto> findSurveyAssistList(SurveyAssistDto searchDto, Page page);

}
