package com.bcxin.risk.order;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.order.dto.data.OrderFormDataDTO;
import com.bcxin.risk.order.dto.search.OrderFormSearchDTO;

import java.util.List;
import java.util.Map;

public interface OrderFormDao extends IDao<OrderForm> {

    OrderForm findOrderFormByOid(Long oid);

    OrderForm findOrderFormByNo(String orderNo);

    List<OrderFormDataDTO> findFinanceOrderFormDtoList(OrderFormSearchDTO searchDto, Page page);

    Map<String, Object> findFinanceOrderFormSummary(OrderFormSearchDTO searchDto);

    List<Map<String, Object>> findFinanceProvince(OrderFormSearchDTO searchDto);

    List<Map<String, Object>> findFinanceOrderFormExportList(OrderFormSearchDTO searchDto);

    List<OrderFormDataDTO> findOrderFormDtoList(OrderFormSearchDTO searchDto, Page page);

    List<OrderFormDataDTO> findServiceOrderList(OrderFormSearchDTO searchDto, Page page);

    OrderForm findOrderFormByAcivity(Activity activity);

    List<OrderFormDataDTO> queryOrderDetail(OrderForm orderForm);

    List<OrderForm>  queryNeedSyncOrder();

    List manageActivityList(OrderFormSearchDTO searchDto, DwzPage page);

    List manageOrderList(OrderFormSearchDTO searchDto, DwzPage page);

    List manageBusinessList(OrderFormSearchDTO searchDto, DwzPage page);

    List manageGovActivityList(OrderFormSearchDTO searchDto, DwzPage page);

    List<OrderFormDataDTO> findServiceOrderListByOrderStatus(OrderFormSearchDTO searchDto, Page page);

    List findExportActivityList(OrderFormSearchDTO searchDto, DwzPage page);

    OrderForm findOrderFormByActivity(Activity activity);

    int countOrder();

    int countActivity();

    int countGovActivity();

    List newOrderFormList();

    List newGovActivity();

    List newActivity();

    Map<String, String> countOrderNum(Long userId);

    /**
     * 可操作发票的订单列表
     *
     * @param searchDto
     * @param page
     * @return
     */
    List<OrderFormDataDTO> findFinanceTicketList(OrderFormSearchDTO searchDto, Page page);
}
