package com.bcxin.risk.expert;

import com.bcxin.risk.expert.domain.ExpertOrderPublic;
import com.bcxin.risk.expert.dto.ExpertOrderPublicDto;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.hibernateplus.entity.page.Page;

import java.util.List;

/**
 * @author hzp
 * 共享专家订单DAO层
 */
public interface ExpertOrderPublicDao extends IDao<ExpertOrderPublic> {

    List<ExpertOrderPublicDto> findOrderList(ExpertOrderPublicDto searchDto, Page page);

    ExpertOrderPublic findExpertByIdWithActivity(Long activityId,Long expertId,String taskType);

    void updateStatusToCancel(Long activityId,String taskType,String taskStatus);

    void updateStatus(Long activityId,Long expertId,String taskType,String taskStatus);

    int selectOrderCountByExpertId(Long userId,String taskType,String taskStatus);
}
