package com.bcxin.risk.user.dao.impl;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.org.ServiceOrgAuthDaoImpl;
import com.bcxin.risk.org.domain.ServiceOrgAuth;
import com.bcxin.risk.org.domain.ServiceOrgAuthDao;
import com.bcxin.risk.user.dao.ExpertRegionDao;
import com.bcxin.risk.user.domain.ExpertRegion;
import com.bcxin.risk.user.domain.ExpertUser;
import com.bcxin.risk.user.domain.User;
import com.bcxin.risk.user.dto.data.ExpertRegionDataDto;
import com.bcxin.risk.user.dto.data.ExpertUserDataDto;
import com.bcxin.risk.user.dto.search.ExpertRegionSearchDto;
import com.bcxin.risk.user.dto.search.ExpertUserSearchDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


@Repository("expertRegionDao")
@SuppressWarnings("unchecked")
public class ExpertRegionDaoImpl extends DaoImpl<ExpertRegion> implements ExpertRegionDao {


    @Autowired
    private ServiceOrgAuthDao serviceOrgAuthDao;

    @Override
    public ExpertRegion findExpertRegionByOid(Long oid){
        return selectById(oid);
    }


    @Override
    public  List<ExpertRegion> findExpertRegionListByOid(long oid){
        return selectList(CriterionWrapper.instance().eq("user_id", oid));
    }


    @Override
    public List<ExpertRegion> findExpertRegionList(ExpertRegionSearchDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (searchDto.getRegion() != null) {
            criterionList.add(Restrictions.eq("region_id", searchDto.getRegion()));
        }
        if (searchDto.getExpertUser() != null) {
            criterionList.add(Restrictions.eq("user_id", searchDto.getExpertUser().getOid()));
        }
        if (page == null) {
            return selectList(criterionList);
        }
        return selectPage(criterionList, page);
    }

    @Override
    public List<ExpertUserDataDto> findExpertUserDataList(ExpertUserSearchDto expertUserSearchDto, Activity activity, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT u.oid, " +
                             "u.realName," +
                             "u.userName," +
                             "u.phone, " +
                             "u.active," +
                             "e.serviceOrg_id," +
                             "e.source," +
                             "e.expertCategory ," +
                             "DATE_FORMAT(u.createOn,'%Y-%m-%d %H:%i:%s')  AS createOn " +
                       "FROM risk_se_user u,risk_expertuser e " +
                      "WHERE e.oid = u.oid " +
                        "AND  u.active = 1 ";
        //                "AND EXISTS( SELECT 1 " +
        //                                "FROM risk_expert_region " +
        //                               "WHERE user_id = e.oid " +
        //                                 "AND region_level = '1' " +
        //                                 "AND region_id = "+ activity.getProvince().getOid()+")";
        //if(activity.getCity() != null){
        //    sql += "AND EXISTS( SELECT 1 " +
        //                           "FROM risk_expert_region " +
        //                          "WHERE user_id = e.oid " +
        //                            "AND region_level = '2' " +
        //                            "AND region_id = "+ activity.getCity().getOid()+")";
        //}

        if (StringUtil.isNotEmpty(expertUserSearchDto.getExpertType())) {
            sql += " and ( e.expertTaskType = 3 or e.expertTaskType = " + expertUserSearchDto.getExpertType() + ")" ;
        }
        if (StringUtil.isNotEmpty(expertUserSearchDto.getKeyName())) {
            sql += " and (u.realName LIKE '%"+expertUserSearchDto.getKeyName() +"%' or e.expertCategory LIKE '%"+expertUserSearchDto.getKeyName() +"%' )";
        }
        if (StringUtil.isNotEmpty(expertUserSearchDto.getName() )){
            sql += " and u.realName LIKE '%"+expertUserSearchDto.getName() +"%' " ;
        }
        if (StringUtil.isNotEmpty(expertUserSearchDto.getExpertCategory() )){
            sql += " and e.expertCategory LIKE '%"+expertUserSearchDto.getExpertCategory() +"%' " ;
        }
        wrapper.orderBy("oid", false);
        List<Map<String, Object>> list = Lists.newArrayList();
        if ( page == null ){
            list = queryMaps(sql, wrapper);
        }else{
            Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
            list = pageList.getRecords();
        }
        List<ExpertUserDataDto> dtoList = new ArrayList<>();

        list.forEach(result ->{
            ExpertUserDataDto dto = new ExpertUserDataDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }


    @Override
    public List<ExpertUserDataDto> findExpertsList(ExpertUserSearchDto expertUserSearchDto, Page page) {
        SelectWrapper wrapper = SelectWrapper.instance();
//        String sql = "SELECT u.oid, u.realName,u.userName,u.phone, u.active,e.serviceOrg_id," +
//                "e.source,e.expertCategory ,e.expertTaskType ,DATE_FORMAT(u.createOn,'%Y-%m-%d %H:%i:%s')  AS createOn " +
//                "  FROM risk_se_user u, risk_expertuser e where e.oid = u.oid and u.usertype != '15' ";


//        String sql = "SELECT u.oid, u.realName,u.userName,u.phone, u.active,u.userType,e.serviceOrg_id," +
//                "e.source,e.expertCategory ,e.expertTaskType ,DATE_FORMAT(u.createOn,'%Y-%m-%d %H:%i:%s') AS createOn, e.professional,e.jobLiveAddr " +
//                "  FROM risk_se_user u, risk_expertuser e where e.oid = u.oid and u.userType != '15' ";

        String sql="SELECT " +
                " u.oid," +
                " u.realName," +
                " u.userName," +
                " u.phone," +
                " u.active," +
                " u.ktType," +
                " CASE" +
                " WHEN (" +
                " u.ktType = '17'" +
                " OR u.ktType = '23'" +
                " OR u.ktType = '24'" +
                " ) THEN" +
                " (" +
                " SELECT" +
                " expertName" +
                " FROM" +
                " risk_expert_type" +
                " WHERE" +
                " expertType = u.ktType" +
                " )" +
                " ELSE" +
                " IF(e.expertTaskType = 1,'勘查专家',IF(e.expertTaskType = 2,'撰写专家','勘查和撰写专家'))" +
//                " f.userTypeName" +
                " END AS userTypeName," +
                " IF(e.expertTaskType = 1 AND u.org_id="+expertUserSearchDto.getOrg().getOid()+",1,0) as 'isUpdateKtType', " +
//                " IF((u.ktType = '8'  OR u.ktType = '17'  OR u.ktType = '23' OR u.ktType = '24') and u.org_id="+expertUserSearchDto.getOrg().getOid()+",1,0) as 'isUpdateKtType', " +
                " e.serviceOrg_id," +
                " e.source," +
                " e.expertCategory," +
                " e.expertTaskType," +
                " e.expertSource," +
                " DATE_FORMAT(" +
                " u.createOn," +
                " '%Y-%m-%d %H:%i:%s'" +
                " ) AS createOn," +
                " e.professional," +
                " g.professionalName," +
                " e.jobLiveAddr" +
                " FROM risk_se_user u" +
                " inner join risk_expertuser e on (u.oid=e.oid and e.checkStatus = 2) " +
//                " left join (SELECT label AS userTypeName, `value` AS ktType FROM sys_dict WHERE type = 'ktType') f on f.ktType = u.ktType " +
                " left join (SELECT label AS professionalName, `value` AS professional FROM sys_dict WHERE type = 'PROFESSIONTYPE') g on g.professional = e.professional " +
//                " WHERE u.active = '1' AND u.ktType IN ('8', '14', '16', '17','23','24') " ;
                " WHERE u.active = '1' AND u.usertype != '15' ";

        if(StringUtil.isNotEmpty(expertUserSearchDto.getUserType())){
            sql += " and u.ktType='"+expertUserSearchDto.getUserType()+"' ";
        }
        if(StringUtil.isNotEmpty(expertUserSearchDto.getLevel())){
            sql += " and e.level='"+expertUserSearchDto.getLevel()+"' ";
        }
        if(StringUtil.isNotEmpty(expertUserSearchDto.getExpertSource())){
            sql += " and e.expertSource='"+expertUserSearchDto.getExpertSource()+"' ";
        }
        // 验证该机构是否有共享专家的权限
        if(expertUserSearchDto.getOrg()!=null){
            if(isShareExpertAuth(expertUserSearchDto.getOrg().getOid())){
                sql += " and (u.org_id="+expertUserSearchDto.getOrg().getOid()+" or e.expertSource='"+DictConst.EXPERT_SOURCE_PUBLIC+"')";
            }else{
                sql += " and (u.org_id="+expertUserSearchDto.getOrg().getOid()+")";
            }
        }

        if (StringUtil.isNotEmpty(expertUserSearchDto.getKeyName())) {
            sql += " and (u.realName LIKE '%"+expertUserSearchDto.getKeyName() +"%' or e.expertCategory LIKE '%"+expertUserSearchDto.getKeyName() +"%' )";
        }
        if (StringUtil.isNotEmpty(expertUserSearchDto.getName() )){
            sql += " and (u.realName LIKE '%"+expertUserSearchDto.getName() +"%' " +
                    " or g.professionalName LIKE '%"+expertUserSearchDto.getName() +"%'" +
                    " or e.jobLiveAddr LIKE '%"+expertUserSearchDto.getName() +"%'" +
                    ")" ;
        }
        if (StringUtil.isNotEmpty(expertUserSearchDto.getExpertCategory() )){
            sql += " and e.expertCategory LIKE '%"+expertUserSearchDto.getExpertCategory() +"%' " ;
        }
        if (StringUtil.isNotEmpty(expertUserSearchDto.getActive())) {
            sql += " and u.active = '"+expertUserSearchDto.getActive() +"' " ;
        }
        if (StringUtil.isNotEmpty(expertUserSearchDto.getExpertType() )){
            /* 默认全能专家全部要查  加上  指定的专家类型*/
            sql += " and (e.expertTaskType = "+ DictConst.EXPERTTASKTYPE_TKZX +" or e.expertTaskType = "+ expertUserSearchDto.getExpertType() +") " ;
        }
        wrapper.orderBy("oid", false);
        List<Map<String, Object>> list = Lists.newArrayList();
        if ( page == null ){
            list = queryMaps(sql, wrapper);
        }else{
            Page<Map<String, Object>> pageList = queryMapsPage(sql, wrapper, page);
            list = pageList.getRecords();
        }
        List<ExpertUserDataDto> dtoList = new ArrayList<>();

        list.forEach(result ->{
            ExpertUserDataDto dto = new ExpertUserDataDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Override
    public List<ExpertRegionDataDto> findExpertRegionListByExpert(ExpertUser expertUser) {
        String sql = " SELECT a.oid," +
                " (CASE WHEN a.level = '1' " +
                " THEN a.province " +
                " WHEN a.level = '2' " +
                " THEN a.city " +
                " ELSE a.area END ) AS area," +
                " a.parent_id," +
                " a.level," +
                " (CASE WHEN (SELECT COUNT(1) " +
                " FROM risk_expert_region " +
                " WHERE region_id = a.oid " +
                " AND user_id = "+ expertUser.getOid() +")>0 " +
                " THEN 1 " +
                " ELSE 0 END) AS xzbz " +
                " FROM sys_region a " +
                " WHERE a.level = 2 " ;
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.orderBy("a.oid", true);
        List<Map<String, Object>> list =  queryMaps( sql,  wrapper);
        List<ExpertRegionDataDto> dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map<String, Object> map = (Map<String, Object>) result;
            ExpertRegionDataDto dto = new ExpertRegionDataDto(map);
            dtoList.add(dto);
        });
        return dtoList ;
    }

    @Override
    public void deleteExpertRegion(User user) {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("user_id", user.getOid());
        delete(wrapper);
    }

    @Override
    public void savemore(String result,long expertOid) {
        String sql = "INSERT INTO risk_expert_region (createOn,user_id,region_level,region_id)  "+
                " SELECT SYSDATE(),"+expertOid+",level,oid" +
                " FROM sys_region WHERE oid IN ("+result+")";

        String sql1 = "INSERT INTO risk_expert_region (createOn,user_id,region_level,region_id)  "+
                      " SELECT SYSDATE(),"+expertOid+",'1',oid" +
                        " FROM sys_region WHERE oid IN (" +
                       "select parent_id from sys_region WHERE" +
                          " oid IN ("+result+"))";
        executeSqlUpdate(sql);
        executeSqlUpdate(sql1);
    }


    /**
     * 共享专家权限
     * @param orgId
     * @return
     */
    public boolean isShareExpertAuth(Long orgId){
        ServiceOrgAuth serviceOrgAuth = serviceOrgAuthDao.selectByType(orgId, DictConst.SERVICEORGAUTH_GXZJ);
        if (serviceOrgAuth == null) {
            return false;
        }
        return DictConst.Y.equals(serviceOrgAuth.getAuthValue());
    }

}
