package com.bcxin.risk.surveytk;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.report.enums.SurveyTaskStatus;
import com.bcxin.risk.survey.domain.SurveyAssist;
import com.bcxin.risk.survey.domain.SurveyTask;
import com.bcxin.risk.surveytk.domain.dto.SurveyAssistDataDto;
import com.bcxin.risk.surveytk.domain.dto.SurveyAssistDto;
import com.bcxin.risk.surveytk.domain.dto.SurveyTaskDataDto;
import com.bcxin.risk.surveytk.domain.dto.SurveyTaskDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author hzp
 * 踏勘任务DAO实现层
 */
@Repository("surveyTkAssistDao")
@SuppressWarnings("unchecked")
public class SurveyTkAssistDaoImpl extends DaoImpl<SurveyAssist> implements SurveyTkAssistDao{

    @Override
    public SurveyAssist findSurveyAssistByOid(Long oid) {
        return selectById(oid);
    }

    @Override
    public List<SurveyAssistDataDto> findSurveyAssistList(SurveyAssistDto searchDto, Page page) {
        List<Map<String, Object>> list = Lists.newArrayList();
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuffer sql = new StringBuffer();
        sql.append("select A.oid,");
        sql.append(" A.reason as applyReason,");
        sql.append(" A.assignType as assistType,");
        sql.append(" A.assignStatus as approvalStatus,");
        sql.append(" DATE_FORMAT(A.createOn,'%Y-%m-%d %H:%i:00') as applyDate,");
        sql.append(" A.experts,A.taskId, A.userId as applyUserId,");
        sql.append(" C.realName as applyUserName,");
        sql.append(" E.`name` as activityName,D.reportUrgent ");
        sql.append(" from RISK_SurveyAssist A,RISK_SURVEYTASK B,risk_se_user C, ");
        sql.append(" risk_report D,risk_activity E, ");
        sql.append(" (select distinct A.org_id orgId,B.oid as activityId from RISK_ACTIVITY_COOPER A,RISK_ACTIVITY B where A.activity_id=B.oid ) F ");
        sql.append(" where A.taskId=B.oid and A.userId=C.oid and D.activity_id=B.activityId ").append("\r\n");
        sql.append(" and E.oid=B.activityId ").append("\r\n");
        sql.append(" and F.activityId=E.oid ").append("\r\n");
        if(searchDto.getOrgId()!=null){
            sql.append(" and F.orgId ="+searchDto.getOrgId()).append("\r\n");
        }
        if(StringUtil.isNotEmpty(searchDto.getAssistType())) {
            sql.append(" and A.assignType ='"+searchDto.getAssistType()+"'").append("\r\n");
        }
        if(StringUtil.isNotEmpty(searchDto.getApprovalStatus())){
            sql.append(" and A.assignStatus = '"+searchDto.getApprovalStatus()+"'").append("\r\n");
        }
        if(StringUtil.isNotEmpty(searchDto.getKeyName())){
            sql.append(" and (A.reason like '%"+searchDto.getKeyName()+"%' or B.`name` like '%"+searchDto.getKeyName()+"%')").append("\r\n");
        }
        wrapper.orderBy("A.createOn", false);

        if ( page == null ){
            list = queryMaps(sql.toString(), wrapper);
        }else{
            Page<Map<String, Object>> pageList = queryMapsPage(sql.toString(), wrapper, page);
            list = pageList.getRecords();
        }

        List<SurveyAssistDataDto> dtoList = new ArrayList<>();
        list.forEach(result ->{
            SurveyAssistDataDto dto = new SurveyAssistDataDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }
}
