package com.bcxin.risk.survey;

import cn.hutool.core.date.DateUtil;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.survey.domain.Survey_Questionnaire;
import com.bcxin.risk.survey.domain.dto.serach.Survey_QuestionnaireSerachDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;


@Repository("survey_QuestionnaireDao")
@SuppressWarnings("unchecked")
public class Survey_QuestionnaireDaoImpl extends DaoImpl<Survey_Questionnaire> implements Survey_QuestionnaireDao {
    public Survey_Questionnaire findSurvey_QuestionnaireByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<Survey_Questionnaire> findSurvey_QuestionnaireList(Survey_QuestionnaireSerachDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getSurveyStep() != null ) {
            criterionList.add(Restrictions.eq("sueveyStep", searchDto.getSurveyStep()));
        }
        if ( page == null ) {
            return selectList(criterionList );
        }
        return selectPage(criterionList ,page);
    }

    /**
     * <b> 半小时内新增或者做过修改的并且有报告地址的记录 </b>
     * @author ZXF
     * @create 2024/04/12 0012 13:37
     * @version
     * @注意事项 </b>
     */
    @Override
    public List<Survey_Questionnaire> findSurveyQuestionnaireListByChange() {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.isNotNull("reportPath"));
        criterionList.add(Restrictions.or(Restrictions.ge("createOn", DateUtil.offsetMinute(new Date(),-30))
                , Restrictions.ge("updateOn", DateUtil.offsetMinute(new Date(),-30))));
        return selectList(criterionList );
    }

}
