package com.bcxin.risk.report.material;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.DeleteWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.report.dto.data.MaterialFormValueDTO;
import com.bcxin.risk.report.dto.search.MaterialFormValueSearchDTO;
import com.bcxin.risk.report.material.dao.MaterialFormValueDao;
import com.bcxin.risk.report.material.domain.MaterialFormAttr;
import com.bcxin.risk.report.material.domain.MaterialFormMenu;
import com.bcxin.risk.report.material.domain.MaterialFormValue;
import com.bcxin.risk.report.material.dto.MaterialComposeValueDTO;
import com.google.common.collect.Lists;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public class MaterialFormValueDaoImpl extends DaoImpl<MaterialFormValue> implements MaterialFormValueDao {

	@Override
	public MaterialFormValue findByActivityAttr(Activity activity, MaterialFormAttr attr, int seq) {
		Criteria criteria = createCriteria(MaterialFormValue.class)
				.add(Restrictions.eq("activity", activity))
				.add(Restrictions.eq("attr", attr))
				.add(Restrictions.eq("seq", seq));
		Object result = criteria.uniqueResult();
		if(result == null) {
			return null;
		} else {
			return (MaterialFormValue)result;
		}
	}

	@Override
	public MaterialFormValue findByOid(Long oid){
		return selectById(oid);
	}

	@Override
	public List<MaterialFormValue> findByActivityAttr(Activity activity, MaterialFormAttr attr) {
		Criteria criteria = createCriteria(MaterialFormValue.class)
				.add(Restrictions.eq("activity", activity))
				.add(Restrictions.eq("attr", attr));
		criteria.addOrder(Order.asc("seq"));
		return criteria.list();
	}


	@Override
	public List<String> findByActivityAttr(Activity activity, String attrCode) {
		SelectWrapper wrapper = SelectWrapper.instance();
		String sql = "select v.value from risk_materialformvalue v  " +
				" inner join risk_materialformattr a on a.oid = v.attr_id ";
		wrapper.eq("v.activity_id",activity.getOid());
		wrapper.eq("a.attrCode",attrCode);
		wrapper.orderBy("v.seq");
		List<Map<String, Object>> list = queryMaps(sql, wrapper);
		List<String> valueList = Lists.newArrayList();
		list.forEach(result->{
			valueList.add(result.get("value")==null?"":result.get("value").toString());
		});
		return valueList;
	}


	@Override
	public List<MaterialFormValueDTO> findDTOByActivity(Activity activity) {
		String sql = "select a.oid as attrId,a.attrCode,a.attrName,a.type as attrType," +
				" a.optionType as optionType,m.menuName,v.seq	,v.value,m.modify " +
				" from risk_materialformvalue v " +
				" inner join risk_materialformattr a on v.attr_id = a.oid " +
				" inner join risk_materialformmenu m on m.oid = a.menu_id " +
				" where v.activity_id = "+activity.getOid()+" order by m.oid,v.seq ";

		List<MaterialFormValueDTO> dtoList = Lists.newArrayList();

		List<Map<String, Object>> list = queryMaps(sql.toString());
		list.forEach(result->{
			Map<String,Object> map = result;
			MaterialFormValueDTO dto = new MaterialFormValueDTO(map);
			dtoList.add(dto);
		});

		return dtoList;
	}


	@Override
	public List<MaterialFormValue> findByActivity(Activity activity) {
		Criteria criteria = createCriteria(MaterialFormValue.class)
				.add(Restrictions.eq("activity", activity));
		return criteria.list();
	}


	@Override
	public List<MaterialFormValue> findByActivityAndAttrs(Activity activity,List<MaterialFormAttr> attrList) {
		Criteria criteria = createCriteria(MaterialFormValue.class)
				.add(Restrictions.eq("activity", activity))
				.add(Restrictions.in("attr",attrList));
		return criteria.list();
	}


	/**
	 * 根据活动查找
	 * @param activity
	 * @return
	 */
	@Override
	public List<com.bcxin.risk.report.material.dto.MaterialFormValueDTO> findAttrValueByActivity(Activity activity) {
		String sql = "select" +
				" attr.oid," +
				" attr.attrCode," +
				" attr.attrName," +
				" attr.type as attrType," +
				" attr.optionType," +
				" v.value " +
				" from risk_materialformvalue v " +
				" inner join risk_materialformattr attr on attr.oid = v.attr_id ";
		SelectWrapper wrapper = SelectWrapper.instance();
		wrapper.eq("attr.activity_id",activity.getOid());
		List<Map<String, Object>> list = queryMaps(sql, wrapper);
		List<com.bcxin.risk.report.material.dto.MaterialFormValueDTO> dtoList = Lists.newArrayList();
		list.forEach(result -> {
			Map<String, Object> map = (Map<String, Object>) result;
			com.bcxin.risk.report.material.dto.MaterialFormValueDTO dto = new com.bcxin.risk.report.material.dto.MaterialFormValueDTO(map);
			dtoList.add(dto);
		});
		return dtoList;
	}


	@Override
	public List<MaterialFormValueDTO> findByActivity(MaterialFormValueSearchDTO searchDTO) {
		String sql = "select v.oid,v.value,a.oid as attrId,v.seq,a.attrCode,a.type as attrType,a.optionType from risk_materialformvalue v" +
				" inner join risk_materialformattr a on v.attr_id = a.oid ";
		SelectWrapper wrapper = SelectWrapper.instance();
		if (searchDTO.getActivity()==null) {
			return Lists.newArrayList();
		}
		if (StringUtil.isNotEmpty(searchDTO.getMenuId())) {
			wrapper.eq("a.menu_id",searchDTO.getMenuId());
		}
		if (StringUtil.isNotEmpty(searchDTO.getSeq())) {
			wrapper.eq("v.seq",searchDTO.getSeq());
		}
		wrapper.eq("v.activity_id",searchDTO.getActivity().getOid());
		List<MaterialFormValueDTO> dtoList = Lists.newArrayList();
		List<Map<String, Object>> list = queryMaps(sql,wrapper);
		list.forEach(result->{
			MaterialFormValueDTO dto = new MaterialFormValueDTO(result);
			dtoList.add(dto);
		});
		return dtoList;
	}


	@Override
	public List<MaterialComposeValueDTO> findByReport(Long report_id) {
		String sql = "select c.classCode,c.className,a.attrCode,m.menuName,m.modify," +
				" (case when v.seq >= 1 then CONCAT('（第',v.seq+1,'个主体）',attrName) else a.attrName end)  attrName, " +
				" a.type as attrType,a.optionType,v.`value` " +
				" from risk_materialformclass c " +
				" inner join risk_materialformmenu m on m.class_id = c.oid " +
				" inner join risk_materialformattr a on a.menu_id = m.oid " +
				" inner join risk_materialformvalue v on v.attr_id = a.oid " +
				" inner join risk_report r on r.activity_id = m.activity_id ";
		SelectWrapper wrapper = SelectWrapper.instance();
		if ( report_id == null) {
			return Lists.newArrayList();
		}
		wrapper.eq("r.oid",report_id);
		wrapper.orderBy("v.seq,v.oid",false);
		List<MaterialComposeValueDTO> dtoList = Lists.newArrayList();
		List<Map<String, Object>> list = queryMaps(sql,wrapper);
		list.forEach(result->{
			MaterialComposeValueDTO dto = new MaterialComposeValueDTO(result);
			dtoList.add(dto);
		});
		return dtoList;
	}


	@Override
	public List<MaterialFormValueDTO> findMultiSeqByActivity(MaterialFormValueSearchDTO searchDTO) {
		String sql = "select DISTINCT v.seq from risk_materialformvalue v " +
				" inner join risk_materialformattr a on v.attr_id = a.oid ";
		SelectWrapper wrapper = SelectWrapper.instance();
		if (searchDTO.getActivity()==null) {
			return Lists.newArrayList();
		}
		if (StringUtil.isNotEmpty(searchDTO.getMenuId())) {
			wrapper.eq("a.menu_id",searchDTO.getMenuId());
		}
		wrapper.eq("a.activity_id",searchDTO.getActivity().getOid());
		List<MaterialFormValueDTO> dtoList = Lists.newArrayList();
		List<Map<String, Object>> list = queryMaps(sql,wrapper);
		list.forEach(result->{
			MaterialFormValueDTO dto = new MaterialFormValueDTO(result);
			dtoList.add(dto);
		});
		return dtoList;
	}


	@Override
	public int deleteByActivityAndAttrs(Activity activity,List<Long> attrIds, int seq) {
		DeleteWrapper wrapper = DeleteWrapper.instance();
		if ( activity == null) {
			return 0;
		}
		wrapper.eq("activity_id",activity.getOid());
		wrapper.in("attr_id",attrIds);
		wrapper.eq("seq",seq);

		return delete(wrapper);
	}

	@Override
	public int findMaxSeq(Activity activity, MaterialFormMenu materialFormMenu) {
		SelectWrapper wrapper = SelectWrapper.instance();
		if ( activity == null || materialFormMenu == null ) {
			return 0;
		}
		String sql = "select max(v.seq) from RISK_MaterialFormValue v inner join risk_materialFormAttr a on a.oid = v.attr_id " +
				" inner join risk_materialFormMenu m on m.oid = a.menu_id ";
		wrapper.eq("v.activity_id",activity.getOid());
		wrapper.eq("m.oid",materialFormMenu.getOid());

		return queryAggregate(sql,wrapper);

	}


	@Override
	public List<MaterialFormValueDTO> findMultiFormValues(Activity activity, MaterialFormMenu menu,String ignoreSeq) {
		SelectWrapper wrapper = SelectWrapper.instance();
		StringBuffer sql = new StringBuffer("select a.oid as attrId,a.attrCode,a.attrName,a.type as attrType,v.seq,v.`value`,a.optionType from risk_MaterialFormValue v "
				+" inner join risk_materialformattr a on a.oid = v.attr_Id "
				+" inner join risk_materialformmenu m on m.oid = a.menu_id ");

		if ( activity == null || menu == null ) {
			return Lists.newArrayList();
		}

		wrapper.eq("m.oid",menu.getOid());
		wrapper.eq("v.activity_id",activity.getOid());
		if (StringUtil.isNotEmpty(ignoreSeq)) {
			wrapper.gt("v.seq",Integer.parseInt(ignoreSeq)-1);
		} else {
			wrapper.gt("v.seq",0);
		}
		wrapper.orderBy("a.seq");
        wrapper.orderBy("a.oid",false);
		List<MaterialFormValueDTO> dtoList = Lists.newArrayList();

		List<Map<String, Object>> list = queryMaps(sql.toString(), wrapper);
		list.forEach(result->{
			Map<String,Object> map = result;
			MaterialFormValueDTO dto = new MaterialFormValueDTO(map);
			dtoList.add(dto);
		});

		return dtoList;
	}


	@Override
	public List<MaterialFormValueDTO> findMultiOrgValues(Activity activity, String menuCode) {
		if ( activity == null || StringUtil.isEmpty(menuCode) ) {
			return Lists.newArrayList();
		}
		StringBuffer sql = new StringBuffer("SELECT b.oid as orgId,c.menuCode" +
				" FROM risk_activity_cooper a , risk_serviceorg b ,risk_materialformorg c" +
				" WHERE a.org_id = b.oid " +
				" AND b.serviceOrgType = c.orgType and a.activity_id = " + activity.getOid() + " and c.menuCode = '"+menuCode+"'");

		List<MaterialFormValueDTO> dtoList = Lists.newArrayList();

		List<Map<String, Object>> list = queryMaps(sql.toString());
		list.forEach(result->{
			Map<String,Object> map = result;
			MaterialFormValueDTO dto = new MaterialFormValueDTO(map);
			dtoList.add(dto);
		});

		return dtoList;
	}


	@Override
	public void updateValue(String value,Long oid){
		String sql = "update risk_materialformvalue set value = '"+value+"' , updateOn = SYSDATE() where oid = " + oid;
		executeSqlUpdate(sql);
	}

	@Override
	public void deleteByActivityId(Long activityId){
		String sql = "delete from risk_materialformvalue where activity_id = " + activityId;
		this.executeSqlUpdate(sql);
	}

	@Override
	public List<Map<String,Object>> selectFormValueMap(Long activityId, Long menuId){
		String sql="select B.menu_id as menuId,CONCAT(B.attrCode,'-',C.seq) as attrCode,B.attrName,C.`value`,B.type as attrType,IFNULL(B.optionType,'') as optionType from risk_materialformmenu A,risk_materialformattr B ,risk_materialformvalue C " +
				" where A.oid=B.menu_id and B.oid=C.attr_id and C.activity_id="+activityId+" and B.menu_id="+menuId+" ORDER BY B.attrCode,C.seq";
		List<Map<String, Object>> list = queryMaps(sql.toString());
		return list;
	}
}
