package com.bcxin.risk.report.material;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.report.material.dao.ContractEvidenceDao;
import com.bcxin.risk.report.material.domain.ContractEvidence;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 合同存证
 *
 * @author Ethan
 */
@Repository("contractEvidenceDao")
public class ContractEvidenceDaoImpl extends DaoImpl<ContractEvidence> implements ContractEvidenceDao {

    public ContractEvidence findByActivity(Activity activity) {
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("activity", activity));
        return selectOne(criterionList);
    }

    public ContractEvidence findContractEvidenceByOid(Long oid) {
        return selectById(oid);
    }
}
