package com.bcxin.risk.policy;

import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.policy.domain.InsuranceProduct;
import com.bcxin.risk.policy.domain.ProductIntroduce;
import com.bcxin.risk.policy.dto.ProductDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository("productIntroduceDao")
@SuppressWarnings("unchecked")

public class ProductIntroduceDaoImpl extends DaoImpl<ProductIntroduce> implements ProductIntroduceDao {

    public ProductIntroduce findProductIntroduceByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public List<ProductIntroduce> findProductIntroduceList(ProductDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if ( searchDto.getIntroduce()!= null ) {
            criterionList.add(Restrictions.eq("introduce", searchDto.getIntroduce()));
        }
        if ( searchDto.getProduct()!= null ) {
            criterionList.add(Restrictions.eq("product", searchDto.getProduct()));
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page);
    }
    @Override
    public ProductIntroduce findProductIntroduceByProduct(InsuranceProduct product) {
        return selectOne(CriterionWrapper.instance().eq("product", product));
    }
}
