package com.bcxin.risk.order;

import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.order.dto.search.TransactionSearchDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @return
 * @auther Administrator
 * @date 2017/04/24 0024
 * @注意事项 </b>
 */

@Repository
@SuppressWarnings("unchecked")
public class TransactionOfflineDaoImpl extends DaoImpl<TransactionOffline> implements TransactionOfflineDao {

    @Override
    public TransactionOffline findTransactionByOid(Long oid){
        return selectById(oid);
    }

    @Override
    public TransactionOffline findTransactionByOrderNo(String orderNo) {
        CriterionWrapper wrapper = CriterionWrapper.instance();
        List list = selectList(wrapper.eq("orderNo", orderNo));
        if (CollectionUtil.isNotEmpty(list)) {
            return (TransactionOffline)list.get(0);
        }
        return null;
    }

    @Override
    public TransactionOffline findTransactionByOrder(OrderForm orderForm) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (orderForm != null ) {
            criterionList.add(Restrictions.eq("orderForm", orderForm));
        }
        return selectOne(criterionList);
    }

}
