package com.bcxin.risk.order;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.order.dto.TransactionDataDto;
import com.bcxin.risk.order.dto.search.TransactionSearchDto;
import com.bcxin.risk.policy.domain.InsurancePolicy;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @return
 * @auther Administrator
 * @date 2017/04/24 0024
 * @注意事项 </b>
 */

@Repository
@SuppressWarnings("unchecked")
public class TransactionDaoImpl extends DaoImpl<Transaction> implements TransactionDao {

    @Override
    public Transaction findTransactionByOid(Long oid) {
        return selectById(oid);
    }
    @Override
    public Transaction findTransactionByPolicy(InsurancePolicy insurancePolicy){
        List<Criterion> criterionList = Lists.newArrayList();
        if (insurancePolicy != null) {
            criterionList.add(Restrictions.eq("insurancePolicy", insurancePolicy));
        }
        return selectOne(criterionList);
    }

    @Override
    public List<Transaction> findTransactionList(TransactionSearchDto searchDto, Page page) {
        List<Criterion> criterionList = Lists.newArrayList();
        if (searchDto != null){
            if (StringUtil.isNotEmpty(searchDto.getOrderNo())) {
                criterionList.add(Restrictions.eq("orderNo", searchDto.getOrderNo()));
            }
            if (searchDto.getOrderForm()!=null) {
                criterionList.add(Restrictions.eq("orderForm", searchDto.getOrderForm()));
            }
        }
        if ( page == null ) {
            return selectList(criterionList);
        }
        return selectPage(criterionList,page,null);
    }

    @Override
    public List<TransactionDataDto> findTransactionByOrderId(Long orderForm_id) {
        String sql = " SELECT b.accountTime AS payTime," +
                " b.confirmAmount AS amount," +
                " b.payOrg AS org," +
                " b.payAccount AS payAccount," +
                " b.payVoucher AS payVoucher," +
                " '' AS payOrderNo," +
                " '' AS product," +
                " a.paymentType AS paymentType,"+
                " a.paymentMode AS  paymentMode " +
                " FROM risk_transaction a ,risk_transactionOffline b " +
                " WHERE a.oid = b.oid " +
                " AND a.orderForm_id = " + orderForm_id +
                " UNION " +
                " SELECT a.endTime AS payTime," +
                " a.amount AS amount," +
                " '' AS  org," +
                " '' AS payAccount," +
                " '' AS payVoucher," +
                " b.payOrderNo AS payOrderNo," +
                " b.product  AS product ," +
                " b.paymentType AS paymentType ,"+
                " a.paymentMode AS  paymentMode " +
                " FROM risk_transaction a ,risk_transactionOnline b " +
                " WHERE a.oid = b.oid " +
                " AND a.orderForm_id = " + orderForm_id;
        List<Map<String, Object>> list = queryMaps(sql);
        List<TransactionDataDto> dtoList = Lists.newArrayList();
        list.forEach(result -> {
            Map<String, Object> map = (Map<String, Object>) result;
            TransactionDataDto dto = new TransactionDataDto(map);
            dtoList.add(dto);
        });
        return dtoList;
    }


    // 查询评估状态提交条件
    @Override
    public Map queryPgbgSubmitConditon(Long orderId) {
        String sql = "SELECT a.activityStatus," +
                             "b.orderStatus," +
                             "c.reportStatus," +
                             "a.oid AS activityId," +
                             "b.oid AS orderId," +
                             "c.oid AS reportId," +
                             "DATE_FORMAT(a.startDate,'%Y-%m-%d %H:%i:%s') AS startDate "+
                "FROM risk_activity a,risk_orderform b ,risk_report c " +
                "WHERE a.oid = b.activity_id " +
                "AND a.oid = c.activity_id ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (orderId != null) {
            sql = sql + "AND b.oid = " + orderId;
        }
        return queryMap(sql, wrapper);
    }

    @Override
    public Transaction findTransactionByOrder(OrderForm orderForm) {

        List<Criterion> criterionList = Lists.newArrayList();
        if (orderForm != null) {
            criterionList.add(Restrictions.eq("orderForm", orderForm));
            criterionList.add(Restrictions.eq("payStatus", DictConst.PAYSTATUS_YZF));
        }
        List list = selectList(criterionList);
        if ( list!=null && list.size() >0) {
            return (Transaction)list.get(0);
        }
        return null;
    }

    @Override
    public Long findTransactionIdByOrder(OrderForm orderForm) {
        String sql = "select oid from risk_transaction ";
        Map<String, Object> map = queryMap(sql, SelectWrapper.instance().eq("orderForm_id", orderForm.getOid()));
        if (map != null) {
            Object object = map.get("oid");
            if (object != null) {
                return Long.parseLong(object.toString());
            }
        }
        return 0L;
    }

    public void deleteTransaction(Long transactionId){

        String sql = "delete from risk_transactiononline where oid = " +transactionId;
        String sql2 = "delete from risk_transaction where oid = " + transactionId;
        executeSqlUpdate(sql);
        executeSqlUpdate(sql2);
    }

    @Override
    public void deleteorderForm(OrderForm orderForm){
        List<Criterion> criterionList = Lists.newArrayList();
        criterionList.add(Restrictions.eq("orderForm",orderForm));
        List<Transaction> transactionList = selectList(criterionList);
        for (Transaction transaction : transactionList){
            String sql1 = "delete from risk_transactionoffline where oid = " +transaction.getOid();
            String sql2 = "delete from risk_transactiononline where oid = " +transaction.getOid();
            String sql3 = "delete from risk_transaction where oid = " + transaction.getOid();
            executeSqlUpdate(sql1);
            executeSqlUpdate(sql2);
            executeSqlUpdate(sql3);
        }
    }

}