package com.bcxin.risk.order;

import com.bcxin.risk.common.domain.Dict;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.user.domain.User;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @return
 * @auther Administrator
 * @date 2017/04/24 0024
 * @注意事项 </b>
 */

@Repository("expertOrderFormDao")
@SuppressWarnings("unchecked")
public class ExpertOrderFormDaoImpl extends DaoImpl<ExpertOrderForm> implements ExpertOrderFormDao {


    @Override
    public List<ExpertOrderForm> findExpertOrderFormList(OrderForm orderForm, User user) {
        SelectWrapper wrapper = SelectWrapper.instance();
        if (orderForm != null) {
            wrapper.eq("orderForm", orderForm);
        }
        if (orderForm != null) {
            wrapper.eq("user", user);
        }
        return selectList(wrapper);
    }


    @Override
    public List<ExpertOrderForm> queryNeedSyncOrder() {
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("isSync", DictConst.N);
        return selectList(wrapper);
    }
}